/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.controller;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/pis"})
@Api(value="api/v1/pis", tags={"PIS, PSU Data"})
public class PisPsuDataController {
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;

    @GetMapping(path={"/payment/{payment-id}/psu-data"})
    @ApiOperation(value="Get PSU data identified by given payment id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<PsuIdData>> getPsuDataByPaymentId(@ApiParam(name="payment-id", value="The payment identification.", example="32454656712432", required=true) @PathVariable(value="payment-id") String paymentId) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.getPsuDataListByPaymentId(paymentId);
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted"})
    public PisPsuDataController(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
    }
}

