/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.controller;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.TppService;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import java.beans.ConstructorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/tpp"})
@Api(value="api/v1/tpp", tags={"TPP"})
public class TppController {
    private final TppService tppService;
    private final TppStopListService tppStopListService;

    @PutMapping
    @ApiOperation(value="Updates TPP Info")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> updateTppInfo(@RequestBody TppInfo tppInfo) {
        CmsResponse response = this.tppService.updateTppInfo(tppInfo);
        return new ResponseEntity((Object)(response.isSuccessful() && (Boolean)response.getPayload() != false ? 1 : 0), HttpStatus.OK);
    }

    @GetMapping(path={"/stop-list"})
    @ApiOperation(value="Checks if TPP is blocked")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> checkIfTppBlocked(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String tppAuthorisationNumber) {
        CmsResponse response = this.tppStopListService.checkIfTppBlocked(tppAuthorisationNumber);
        return new ResponseEntity((Object)(response.isSuccessful() && (Boolean)response.getPayload() != false ? 1 : 0), HttpStatus.OK);
    }

    @ConstructorProperties(value={"tppService", "tppStopListService"})
    public TppController(TppService tppService, TppStopListService tppStopListService) {
        this.tppService = tppService;
        this.tppStopListService = tppStopListService;
    }
}

