/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report.entity;

import de.adorsys.psd2.consent.domain.PsuDataEmbeddable;
import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.report.entity.EventConsentEntity;
import de.adorsys.psd2.report.entity.EventPaymentEntity;
import java.time.OffsetDateTime;
import java.util.Arrays;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="event")
public class EventReportEntity {
    static final String DEFAULT_SERVICE_INSTANCE_ID = "UNDEFINED";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="event_generator")
    @SequenceGenerator(name="event_generator", sequenceName="event_id_seq", allocationSize=1)
    private Long id;
    @Column(name="timestamp", nullable=false)
    private OffsetDateTime timestamp;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="consent_id", referencedColumnName="external_id")
    private EventConsentEntity consent;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="payment_id", referencedColumnName="payment_id")
    private EventPaymentEntity payment;
    @Lob
    @Column(name="payload")
    private byte[] payload;
    @Column(name="event_origin", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EventOrigin eventOrigin;
    @Column(name="event_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private EventType eventType;
    @Embedded
    private PsuDataEmbeddable psuData;
    @Column(name="tpp_authorisation_number")
    private String tppAuthorisationNumber;
    @Column(name="x_request_id")
    private String xRequestId;
    @Column(name="instance_id", nullable=false, updatable=false)
    private String instanceId = "UNDEFINED";
    @Column(name="internal_request_id")
    private String internalRequestId;

    public Long getId() {
        return this.id;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public EventConsentEntity getConsent() {
        return this.consent;
    }

    public EventPaymentEntity getPayment() {
        return this.payment;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public EventOrigin getEventOrigin() {
        return this.eventOrigin;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public PsuDataEmbeddable getPsuData() {
        return this.psuData;
    }

    public String getTppAuthorisationNumber() {
        return this.tppAuthorisationNumber;
    }

    public String getXRequestId() {
        return this.xRequestId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setConsent(EventConsentEntity consent) {
        this.consent = consent;
    }

    public void setPayment(EventPaymentEntity payment) {
        this.payment = payment;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setEventOrigin(EventOrigin eventOrigin) {
        this.eventOrigin = eventOrigin;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public void setPsuData(PsuDataEmbeddable psuData) {
        this.psuData = psuData;
    }

    public void setTppAuthorisationNumber(String tppAuthorisationNumber) {
        this.tppAuthorisationNumber = tppAuthorisationNumber;
    }

    public void setXRequestId(String xRequestId) {
        this.xRequestId = xRequestId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInternalRequestId(String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventReportEntity)) {
            return false;
        }
        EventReportEntity other = (EventReportEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        OffsetDateTime this$timestamp = this.getTimestamp();
        OffsetDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        EventConsentEntity this$consent = this.getConsent();
        EventConsentEntity other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        EventPaymentEntity this$payment = this.getPayment();
        EventPaymentEntity other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
            return false;
        }
        if (!Arrays.equals(this.getPayload(), other.getPayload())) {
            return false;
        }
        EventOrigin this$eventOrigin = this.getEventOrigin();
        EventOrigin other$eventOrigin = other.getEventOrigin();
        if (this$eventOrigin == null ? other$eventOrigin != null : !this$eventOrigin.equals(other$eventOrigin)) {
            return false;
        }
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        PsuDataEmbeddable this$psuData = this.getPsuData();
        PsuDataEmbeddable other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !this$psuData.equals(other$psuData)) {
            return false;
        }
        String this$tppAuthorisationNumber = this.getTppAuthorisationNumber();
        String other$tppAuthorisationNumber = other.getTppAuthorisationNumber();
        if (this$tppAuthorisationNumber == null ? other$tppAuthorisationNumber != null : !this$tppAuthorisationNumber.equals(other$tppAuthorisationNumber)) {
            return false;
        }
        String this$xRequestId = this.getXRequestId();
        String other$xRequestId = other.getXRequestId();
        if (this$xRequestId == null ? other$xRequestId != null : !this$xRequestId.equals(other$xRequestId)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        return !(this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventReportEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        OffsetDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        EventConsentEntity $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        EventPaymentEntity $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        EventOrigin $eventOrigin = this.getEventOrigin();
        result = result * 59 + ($eventOrigin == null ? 43 : $eventOrigin.hashCode());
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        PsuDataEmbeddable $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : $psuData.hashCode());
        String $tppAuthorisationNumber = this.getTppAuthorisationNumber();
        result = result * 59 + ($tppAuthorisationNumber == null ? 43 : $tppAuthorisationNumber.hashCode());
        String $xRequestId = this.getXRequestId();
        result = result * 59 + ($xRequestId == null ? 43 : $xRequestId.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        return result;
    }

    public String toString() {
        return "EventReportEntity(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", consent=" + this.getConsent() + ", payment=" + this.getPayment() + ", payload=" + Arrays.toString(this.getPayload()) + ", eventOrigin=" + this.getEventOrigin() + ", eventType=" + this.getEventType() + ", psuData=" + this.getPsuData() + ", tppAuthorisationNumber=" + this.getTppAuthorisationNumber() + ", xRequestId=" + this.getXRequestId() + ", instanceId=" + this.getInstanceId() + ", internalRequestId=" + this.getInternalRequestId() + ")";
    }
}

