/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report.mapper;

import de.adorsys.psd2.consent.domain.PsuDataEmbeddable;
import de.adorsys.psd2.event.persist.model.PsuIdDataPO;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.report.entity.EventPsuDataList;
import de.adorsys.psd2.report.entity.EventReportEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface EventReportDBMapper {
    @Mappings(value={@Mapping(target="consentId", source="event.consent.externalId"), @Mapping(target="paymentId", source="event.payment.paymentId")})
    public ReportEvent mapToReportEvent(EventReportEntity var1);

    @AfterMapping
    default public void mapToReportEventAfterMappingFromEventEntity(EventReportEntity event, @MappingTarget ReportEvent reportEvent) {
        reportEvent.setPsuIdData(this.getPsuIdDataPOSet(event));
    }

    default public Set<PsuIdDataPO> getPsuIdDataPOSet(EventReportEntity event) {
        HashSet<PsuIdDataPO> psus = new HashSet<PsuIdDataPO>();
        PsuDataEmbeddable psuDataEmbeddable = event.getPsuData();
        if (psuDataEmbeddable != null && psuDataEmbeddable.getPsuId() != null) {
            psus.add(this.mapToPsuIdDataPO(psuDataEmbeddable.getPsuId(), psuDataEmbeddable.getPsuIdType(), psuDataEmbeddable.getPsuCorporateId(), psuDataEmbeddable.getPsuCorporateIdType()));
        }
        this.populateByPsuIdDataPO(psus, event.getConsent());
        this.populateByPsuIdDataPO(psus, event.getPayment());
        return psus;
    }

    default public void populateByPsuIdDataPO(Set<PsuIdDataPO> psus, EventPsuDataList eventPsuDataList) {
        if (eventPsuDataList != null && CollectionUtils.isNotEmpty(eventPsuDataList.getPsuDataList())) {
            psus.addAll(eventPsuDataList.getPsuDataList().stream().map(p -> this.mapToPsuIdDataPO(p.getPsuId(), p.getPsuIdType(), p.getPsuCorporateId(), p.getPsuCorporateIdType())).collect(Collectors.toList()));
        }
    }

    default public PsuIdDataPO mapToPsuIdDataPO(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        PsuIdDataPO psuIdDataPO = new PsuIdDataPO();
        psuIdDataPO.setPsuId(psuId);
        psuIdDataPO.setPsuIdType(psuIdType);
        psuIdDataPO.setPsuCorporateId(psuCorporateId);
        psuIdDataPO.setPsuCorporateIdType(psuCorporateIdType);
        return psuIdDataPO;
    }

    default public List<ReportEvent> mapToAspspReportEvents(List<EventReportEntity> events) {
        Collection eventCollection = events.stream().map(this::mapToReportEvent).collect(Collectors.toMap(ReportEvent::getId, Function.identity(), ReportEvent::merge)).values();
        return new ArrayList<ReportEvent>(eventCollection);
    }
}

