/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report.specification;

import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.report.entity.EventReportEntity;
import de.adorsys.psd2.report.specification.EventEntityAttributeSpecificationProvider;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EventSpecification {
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String INSTANCE_ID_ATTRIBUTE = "instanceId";
    private static final String CONSENT_ID_ATTRIBUTE = "externalId";
    private static final String PAYMENT_ID_ATTRIBUTE = "paymentId";
    private static final String EVENT_TYPE_ATTRIBUTE = "eventType";
    private static final String EVENT_ORIGIN_ATTRIBUTE = "eventOrigin";
    private static final String CONSENT_ATTRIBUTE = "consent";
    private static final String PAYMENT_ATTRIBUTE = "payment";

    public Specification<EventReportEntity> byPeriodAndInstanceId(OffsetDateTime start, OffsetDateTime end, String instanceId) {
        return Optional.of(this.byPeriod(start, end)).map(s -> s.and(this.byInstanceId(instanceId))).orElse(null);
    }

    private Specification<EventReportEntity> byPeriod(@Nullable OffsetDateTime start, @Nullable OffsetDateTime end) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get(TIMESTAMP_ATTRIBUTE))});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (start != null) {
                predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(TIMESTAMP_ATTRIBUTE), (Comparable)start));
            }
            if (end != null) {
                predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(TIMESTAMP_ATTRIBUTE), (Comparable)end));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }

    protected Specification<EventReportEntity> byInstanceId(@Nullable String instanceId) {
        return EventEntityAttributeSpecificationProvider.provideSpecificationForEntityAttribute(INSTANCE_ID_ATTRIBUTE, instanceId);
    }

    public Specification<EventReportEntity> byPeriodAndInstanceIdAndConsentId(OffsetDateTime start, OffsetDateTime end, String instanceId, String consentId) {
        return Optional.of(this.byPeriod(start, end)).map(s -> s.and(this.byInstanceId(instanceId))).map(s -> s.and(this.byConsentId(consentId))).orElse(null);
    }

    private Specification<EventReportEntity> byConsentId(@Nullable String consentId) {
        if (consentId == null) {
            return null;
        }
        return (Specification & Serializable)(root, query, cb) -> {
            Join consentEntityJoin = root.join(CONSENT_ATTRIBUTE);
            return Optional.of(Specification.where(EventEntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(consentEntityJoin, CONSENT_ID_ATTRIBUTE, consentId))).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    public Specification<EventReportEntity> byPeriodAndInstanceIdAndPaymentId(OffsetDateTime start, OffsetDateTime end, String instanceId, String paymentId) {
        return Optional.of(this.byPeriod(start, end)).map(s -> s.and(this.byInstanceId(instanceId))).map(s -> s.and(this.byPaymentId(paymentId))).orElse(null);
    }

    private Specification<EventReportEntity> byPaymentId(@Nullable String paymentId) {
        if (paymentId == null) {
            return null;
        }
        return (Specification & Serializable)(root, query, cb) -> {
            Join paymentEntityJoin = root.join(PAYMENT_ATTRIBUTE);
            return Optional.of(Specification.where(EventEntityAttributeSpecificationProvider.provideSpecificationForJoinedEntityAttribute(paymentEntityJoin, PAYMENT_ID_ATTRIBUTE, paymentId))).map(s -> s.toPredicate(root, query, cb)).orElse(null);
        };
    }

    public Specification<EventReportEntity> byPeriodAndInstanceIdAndEventType(OffsetDateTime start, OffsetDateTime end, String instanceId, EventType eventType) {
        return Optional.of(this.byPeriod(start, end)).map(s -> s.and(this.byInstanceId(instanceId))).map(s -> s.and(this.byEventType(eventType))).orElse(null);
    }

    private Specification<EventReportEntity> byEventType(@NotNull EventType eventType) {
        return EventEntityAttributeSpecificationProvider.provideSpecificationForEntityObjectAttribute(EVENT_TYPE_ATTRIBUTE, eventType);
    }

    public Specification<EventReportEntity> byPeriodAndInstanceIdAndEventOrigin(OffsetDateTime start, OffsetDateTime end, String instanceId, EventOrigin eventOrigin) {
        return Optional.of(this.byPeriod(start, end)).map(s -> s.and(this.byInstanceId(instanceId))).map(s -> s.and(this.byEventOrigin(eventOrigin))).orElse(null);
    }

    private Specification<EventReportEntity> byEventOrigin(@NotNull EventOrigin eventOrigin) {
        return EventEntityAttributeSpecificationProvider.provideSpecificationForEntityObjectAttribute(EVENT_ORIGIN_ATTRIBUTE, eventOrigin);
    }
}

