/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report;

import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.event.persist.EventReportRepository;
import de.adorsys.psd2.event.persist.model.ReportEvent;
import de.adorsys.psd2.report.entity.EventEntityForReport;
import de.adorsys.psd2.report.jpa.EventReportJPARepository;
import de.adorsys.psd2.report.mapper.EventReportDBMapper;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EventReportRepositoryImpl
implements EventReportRepository {
    private final EventReportJPARepository eventReportJPARepository;
    private final EventReportDBMapper eventReportDBMapper;

    public List<ReportEvent> getEventsForPeriod(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @Nullable String instanceId) {
        List<EventEntityForReport> events = this.eventReportJPARepository.getEventsForPeriod(start, end, instanceId);
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndConsentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String consentId, @Nullable String instanceId) {
        List<EventEntityForReport> events = this.eventReportJPARepository.findByTimestampBetweenAndConsentIdAndInstanceIdOrderByTimestampAsc(start, end, consentId, instanceId);
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndPaymentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String paymentId, @Nullable String instanceId) {
        List<EventEntityForReport> events = this.eventReportJPARepository.findByTimestampBetweenAndPaymentIdAndInstanceIdOrderByTimestampAsc(start, end, paymentId, instanceId);
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndEventType(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventType eventType, @Nullable String instanceId) {
        List<EventEntityForReport> events = this.eventReportJPARepository.findByTimestampBetweenAndEventTypeAndInstanceIdOrderByTimestampAsc(start, end, eventType, instanceId);
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    public List<ReportEvent> getEventsForPeriodAndEventOrigin(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventOrigin eventOrigin, @Nullable String instanceId) {
        List<EventEntityForReport> events = this.eventReportJPARepository.findByTimestampBetweenAndEventOriginAndInstanceIdOrderByTimestampAsc(start, end, eventOrigin, instanceId);
        return this.eventReportDBMapper.mapToAspspReportEvents(events);
    }

    @ConstructorProperties(value={"eventReportJPARepository", "eventReportDBMapper"})
    public EventReportRepositoryImpl(EventReportJPARepository eventReportJPARepository, EventReportDBMapper eventReportDBMapper) {
        this.eventReportJPARepository = eventReportJPARepository;
        this.eventReportDBMapper = eventReportDBMapper;
    }
}

