/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.service.AuthorizationService;
import feign.FeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationServiceImpl.class);
    private final UserMgmtRestClient userMgmtRestClient;
    private static final String LOGIN_ERROR_MSG_LOGGER = "Error during login operation for user: {}, status: {}, message: {}";
    private static final String LOGIN_ERROR_MSG = "Error during login operation for user: %s";

    public SCALoginResponseTO login(String login, String pin) {
        try {
            return (SCALoginResponseTO)this.userMgmtRestClient.authorise(login, pin, UserRoleTO.CUSTOMER).getBody();
        }
        catch (FeignException e) {
            log.error(LOGIN_ERROR_MSG_LOGGER, new Object[]{login, e.status(), e.getMessage()});
            throw AuthorizationException.builder().devMessage(String.format(LOGIN_ERROR_MSG, login)).errorCode(AuthErrorCode.LOGIN_FAILED).build();
        }
    }

    public AuthorizationServiceImpl(UserMgmtRestClient userMgmtRestClient) {
        this.userMgmtRestClient = userMgmtRestClient;
    }
}

