/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.middleware.client.mappers.PaymentMapperTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.OauthRestClient;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import de.adorsys.ledgers.oba.service.impl.mapper.PaymentMapper;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.pis.CmsCommonPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Optional;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonPaymentServiceImpl
implements CommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(CommonPaymentServiceImpl.class);
    private final ConsentReferencePolicy referencePolicy;
    private final AuthRequestInterceptor authInterceptor;
    private final CmsPsuPisService cmsPsuPisService;
    private final PaymentRestClient paymentRestClient;
    private final AspspConsentDataClient aspspConsentDataClient;
    private final TokenStorageService tokenStorageService;
    private final PaymentMapperTO paymentMapper;
    private final PaymentMapper paymentConverter;
    private final OauthRestClient oauthRestClient;

    public PaymentWorkflow selectScaForPayment(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndAccessTokenCookieString, boolean isCancellationOperation, String psuId, BearerTokenTO tokenTO) {
        PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndAccessTokenCookieString, psuId, tokenTO);
        this.selectMethodAndUpdateWorkflow(scaMethodId, workflow, isCancellationOperation);
        this.doUpdateAuthData(psuId, workflow);
        return workflow;
    }

    public PaymentWorkflow identifyPayment(String encryptedPaymentId, String authorizationId, boolean strict, String consentCookieString, String psuId, BearerTokenTO bearerToken) {
        ConsentReference consentReference = this.referencePolicy.fromRequest(encryptedPaymentId, authorizationId, consentCookieString, strict);
        CmsPaymentResponse cmsPaymentResponse = this.loadPaymentByRedirectId(consentReference);
        PaymentWorkflow workflow = new PaymentWorkflow(cmsPaymentResponse, consentReference);
        PaymentTO payment = this.getPaymentTO(workflow);
        workflow.setAuthResponse(new PaymentAuthorizeResponse(payment));
        workflow.getAuthResponse().setAuthorisationId(cmsPaymentResponse.getAuthorisationId());
        workflow.getAuthResponse().setEncryptedConsentId(encryptedPaymentId);
        workflow.setPaymentStatus(Optional.ofNullable(payment.getTransactionStatus()).map(Enum::name).orElse("RCVD"));
        if (bearerToken != null) {
            SCAPaymentResponseTO scaPaymentResponseTO = new SCAPaymentResponseTO();
            scaPaymentResponseTO.setBearerToken(bearerToken);
            workflow.setScaResponse((SCAResponseTO)scaPaymentResponseTO);
        }
        return workflow;
    }

    public void updateAspspConsentData(PaymentWorkflow paymentWorkflow) {
        CmsAspspConsentDataBase64 consentData;
        try {
            consentData = new CmsAspspConsentDataBase64(paymentWorkflow.paymentId(), this.tokenStorageService.toBase64String(paymentWorkflow.getScaResponse()));
        }
        catch (IOException e) {
            throw AuthorizationException.builder().errorCode(AuthErrorCode.CONSENT_DATA_UPDATE_FAILED).devMessage("Consent data update failed").build();
        }
        this.aspspConsentDataClient.updateAspspConsentData(paymentWorkflow.getConsentReference().getEncryptedConsentId(), consentData);
    }

    public String resolveRedirectUrl(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, boolean isOauth2Integrated, String psuId, BearerTokenTO tokenTO, String authConfirmationCode) {
        PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndAccessTokenCookieString, psuId, tokenTO);
        CmsPaymentResponse consentResponse = workflow.getPaymentResponse();
        this.authInterceptor.setAccessToken(workflow.getScaResponse().getBearerToken().getAccess_token());
        String tppOkRedirectUri = isOauth2Integrated ? ((OauthCodeResponseTO)this.oauthRestClient.oauthCode(consentResponse.getTppOkRedirectUri()).getBody()).getRedirectUri() : this.buildTppOkRedirectUri(consentResponse.getTppOkRedirectUri(), authConfirmationCode);
        String tppNokRedirectUri = consentResponse.getTppNokRedirectUri();
        ScaStatusTO scaStatus = this.loadAuthorization(workflow.authId());
        return EnumSet.of(ScaStatusTO.FINALISED, ScaStatusTO.UNCONFIRMED).contains(scaStatus) ? tppOkRedirectUri : tppNokRedirectUri;
    }

    private String buildTppOkRedirectUri(String tppOkRedirectUri, String authConfirmationCode) {
        String authCodeParam = StringUtils.isNotBlank((CharSequence)authConfirmationCode) ? "?authConfirmationCode=" + authConfirmationCode : "";
        return tppOkRedirectUri + authCodeParam;
    }

    public PaymentWorkflow initiatePayment(PaymentWorkflow paymentWorkflow, String psuId) {
        this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
        SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.initiatePayment(paymentWorkflow.paymentType(), paymentWorkflow.getAuthResponse().getPayment()).getBody();
        paymentWorkflow.processSCAResponse((SCAResponseTO)paymentResponseTO);
        paymentWorkflow.setPaymentStatus(paymentResponseTO.getTransactionStatus().name());
        this.doUpdateAuthData(psuId, paymentWorkflow);
        return paymentWorkflow;
    }

    public PaymentWorkflow initiateCancelPayment(PaymentWorkflow paymentWorkflow, String psuId) {
        this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
        SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.initiatePmtCancellation(paymentWorkflow.paymentId()).getBody();
        paymentWorkflow.processSCAResponse((SCAResponseTO)paymentResponseTO);
        paymentWorkflow.setPaymentStatus(paymentResponseTO.getTransactionStatus().name());
        this.doUpdateAuthData(psuId, paymentWorkflow);
        return paymentWorkflow;
    }

    public PaymentWorkflow authorizePayment(PaymentWorkflow paymentWorkflow, String psuId, String authCode) {
        this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
        SCAPaymentResponseTO scaPaymentResponse = (SCAPaymentResponseTO)this.paymentRestClient.authorizePayment(paymentWorkflow.paymentId(), paymentWorkflow.authId(), authCode).getBody();
        paymentWorkflow.processSCAResponse((SCAResponseTO)scaPaymentResponse);
        paymentWorkflow.setPaymentStatus(scaPaymentResponse.getTransactionStatus().name());
        this.doUpdateAuthData(psuId, paymentWorkflow);
        return paymentWorkflow;
    }

    public PaymentWorkflow authorizeCancelPayment(PaymentWorkflow paymentWorkflow, String psuId, String authCode) {
        this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
        SCAPaymentResponseTO scaPaymentResponse = (SCAPaymentResponseTO)this.paymentRestClient.authorizeCancelPayment(paymentWorkflow.paymentId(), paymentWorkflow.authId(), authCode).getBody();
        paymentWorkflow.processSCAResponse((SCAResponseTO)scaPaymentResponse);
        paymentWorkflow.setPaymentStatus(TransactionStatusTO.CANC.toString());
        this.doUpdateAuthData(psuId, paymentWorkflow);
        return paymentWorkflow;
    }

    private void doUpdateAuthData(String psuId, PaymentWorkflow workflow) {
        this.updateAuthorisationStatus(workflow, psuId);
        this.updatePaymentStatus(workflow);
        this.updateAspspConsentData(workflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectMethodAndUpdateWorkflow(String scaMethodId, PaymentWorkflow workflow, boolean isCancellationOperation) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO paymentResponseTO = isCancellationOperation ? (SCAPaymentResponseTO)this.paymentRestClient.selecCancelPaymentSCAtMethod(workflow.paymentId(), workflow.authId(), scaMethodId).getBody() : (SCAPaymentResponseTO)this.paymentRestClient.selectMethod(workflow.paymentId(), workflow.authId(), scaMethodId).getBody();
            workflow.processSCAResponse((SCAResponseTO)paymentResponseTO);
            workflow.setPaymentStatus(paymentResponseTO.getTransactionStatus().name());
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void updateAuthorisationStatus(PaymentWorkflow workflow, String psuId) {
        String paymentId = workflow.getPaymentResponse().getPayment().getPaymentId();
        String authorisationId = workflow.getPaymentResponse().getAuthorisationId();
        String status = workflow.getAuthResponse().getScaStatus().name();
        try {
            this.cmsPsuPisService.updateAuthorisationStatus(new PsuIdData(psuId, null, null, null, null), paymentId, authorisationId, ScaStatus.valueOf((String)status), "UNDEFINED", new AuthenticationDataHolder(null, workflow.getScaResponse().getAuthConfirmationCode()));
        }
        catch (AuthorisationIsExpiredException e) {
            log.error("Authorization for your payment has expired!");
            throw ObaException.builder().obaErrorCode(ObaErrorCode.AUTH_EXPIRED).devMessage(e.getMessage()).build();
        }
    }

    private CmsPaymentResponse loadPaymentByRedirectId(ConsentReference consentReference) {
        String redirectId = consentReference.getRedirectId();
        try {
            return (CmsPaymentResponse)this.cmsPsuPisService.checkRedirectAndGetPayment(redirectId, "UNDEFINED").orElseThrow(() -> new RedirectUrlIsExpiredException(null));
        }
        catch (RedirectUrlIsExpiredException e) {
            throw ObaException.builder().obaErrorCode(ObaErrorCode.NOT_FOUND).devMessage(String.format("Could not retrieve payment %s from CMS", redirectId)).build();
        }
    }

    private ScaStatusTO loadAuthorization(String authorizationId) {
        return this.cmsPsuPisService.getAuthorisationByAuthorisationId(authorizationId, "UNDEFINED").map(CmsPsuAuthorisation::getScaStatus).map(Enum::name).map(ScaStatusTO::valueOf).orElseThrow(() -> ObaException.builder().obaErrorCode(ObaErrorCode.NOT_FOUND).devMessage("Authorization for payment not found!").build());
    }

    private void updatePaymentStatus(PaymentWorkflow paymentWorkflow) {
        this.cmsPsuPisService.updatePaymentStatus(paymentWorkflow.getPaymentResponse().getPayment().getPaymentId(), TransactionStatus.valueOf((String)paymentWorkflow.getPaymentStatus()), "UNDEFINED");
        paymentWorkflow.getAuthResponse().getPayment().setTransactionStatus(TransactionStatusTO.valueOf((String)paymentWorkflow.getPaymentStatus()));
    }

    private PaymentTO getPaymentTO(PaymentWorkflow workflow) {
        CmsCommonPayment payment = (CmsCommonPayment)workflow.getPaymentResponse().getPayment();
        String paymentString = new String(payment.getPaymentData(), StandardCharsets.UTF_8);
        PaymentTO abstractPayment = this.paymentMapper.toAbstractPayment(paymentString, workflow.paymentType().name(), payment.getPaymentProduct());
        abstractPayment.setPaymentId(workflow.paymentId());
        abstractPayment.setTransactionStatus(this.paymentConverter.toTransactionStatusTO(payment.getTransactionStatus()));
        return abstractPayment;
    }

    public CommonPaymentServiceImpl(ConsentReferencePolicy referencePolicy, AuthRequestInterceptor authInterceptor, CmsPsuPisService cmsPsuPisService, PaymentRestClient paymentRestClient, AspspConsentDataClient aspspConsentDataClient, TokenStorageService tokenStorageService, PaymentMapperTO paymentMapper, PaymentMapper paymentConverter, OauthRestClient oauthRestClient) {
        this.referencePolicy = referencePolicy;
        this.authInterceptor = authInterceptor;
        this.cmsPsuPisService = cmsPsuPisService;
        this.paymentRestClient = paymentRestClient;
        this.aspspConsentDataClient = aspspConsentDataClient;
        this.tokenStorageService = tokenStorageService;
        this.paymentMapper = paymentMapper;
        this.paymentConverter = paymentConverter;
        this.oauthRestClient = oauthRestClient;
    }
}

