/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.cms.impl.mapper;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AccountAccessInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AisConsent;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.PsuInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyRedirectUri;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.UserAccountInfo;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(componentModel="spring")
public interface AisConsentMapper {
    @Mapping(target="psuData", source="psuInfo")
    public CreateAisConsentRequest toCmsAisConsentRequest(AisConsent var1);

    public AisAccountAccessInfo toAisAccountAccessInfo(AccountAccessInfo var1);

    default public AccountInfo toAccountInfo(UserAccountInfo userAccountInfo) {
        return Optional.ofNullable(userAccountInfo).map(i -> AccountInfo.builder().resourceId(i.getResourceId()).aspspAccountId(i.getAspspAccountId()).accountIdentifier(i.getAccountIdentifier()).accountReferenceType(AccountReferenceType.valueOf((String)i.getAccountType().name())).currency(i.getCurrency()).build()).orElseGet(() -> AccountInfo.builder().build());
    }

    default public PsuIdData toPsuIdData(PsuInfo psuInfo) {
        return Optional.ofNullable(psuInfo).map(p -> new PsuIdData(p.getPsuId(), p.getPsuIdType(), p.getPsuCorporateId(), p.getPsuCorporateIdType(), null)).orElseGet(PsuIdData::new);
    }

    default public TppRedirectUri toTppRedirectUti(ThirdPartyRedirectUri redirectUri) {
        return Optional.ofNullable(redirectUri).map(u -> new TppRedirectUri(u.getUri(), u.getNokUri())).orElseGet(() -> new TppRedirectUri("", null));
    }
}

