/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.cms.impl.mapper;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AccountAccessInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AisConsent;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyRole;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.UserAccountAccessType;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.UserAccountInfo;
import de.adorsys.psd2.sandbox.tpp.cms.impl.mapper.AisConsentMapper;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapperImpl
implements AisConsentMapper {
    @Override
    public CreateAisConsentRequest toCmsAisConsentRequest(AisConsent aisConsent) {
        if (aisConsent == null) {
            return null;
        }
        CreateAisConsentRequest createAisConsentRequest = new CreateAisConsentRequest();
        createAisConsentRequest.setPsuData(this.toPsuIdData(aisConsent.getPsuInfo()));
        createAisConsentRequest.setTppInfo(this.thirdPartyInfoToTppInfo(aisConsent.getTppInfo()));
        createAisConsentRequest.setAllowedFrequencyPerDay(aisConsent.getAllowedFrequencyPerDay());
        createAisConsentRequest.setRequestedFrequencyPerDay(aisConsent.getRequestedFrequencyPerDay());
        createAisConsentRequest.setAccess(this.toAisAccountAccessInfo(aisConsent.getAccess()));
        createAisConsentRequest.setValidUntil(aisConsent.getValidUntil());
        createAisConsentRequest.setRecurringIndicator(aisConsent.isRecurringIndicator());
        createAisConsentRequest.setTppRedirectPreferred(aisConsent.isTppRedirectPreferred());
        createAisConsentRequest.setCombinedServiceIndicator(aisConsent.isCombinedServiceIndicator());
        return createAisConsentRequest;
    }

    @Override
    public AisAccountAccessInfo toAisAccountAccessInfo(AccountAccessInfo info) {
        if (info == null) {
            return null;
        }
        AisAccountAccessInfo aisAccountAccessInfo = new AisAccountAccessInfo();
        aisAccountAccessInfo.setAccounts(this.userAccountInfoListToAccountInfoList(info.getAccounts()));
        aisAccountAccessInfo.setBalances(this.userAccountInfoListToAccountInfoList(info.getBalances()));
        aisAccountAccessInfo.setTransactions(this.userAccountInfoListToAccountInfoList(info.getTransactions()));
        aisAccountAccessInfo.setAvailableAccounts(this.userAccountAccessTypeToAccountAccessType(info.getAvailableAccounts()));
        aisAccountAccessInfo.setAllPsd2(this.userAccountAccessTypeToAccountAccessType(info.getAllPsd2()));
        aisAccountAccessInfo.setAvailableAccountsWithBalance(this.userAccountAccessTypeToAccountAccessType(info.getAvailableAccountsWithBalance()));
        return aisAccountAccessInfo;
    }

    protected TppRole thirdPartyRoleToTppRole(ThirdPartyRole thirdPartyRole) {
        TppRole tppRole;
        if (thirdPartyRole == null) {
            return null;
        }
        switch (thirdPartyRole) {
            case PISP: {
                tppRole = TppRole.PISP;
                break;
            }
            case AISP: {
                tppRole = TppRole.AISP;
                break;
            }
            case PIISP: {
                tppRole = TppRole.PIISP;
                break;
            }
            case ASPSP: {
                tppRole = TppRole.ASPSP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + thirdPartyRole);
            }
        }
        return tppRole;
    }

    protected List<TppRole> thirdPartyRoleListToTppRoleList(List<ThirdPartyRole> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TppRole> list1 = new ArrayList<TppRole>(list.size());
        for (ThirdPartyRole thirdPartyRole : list) {
            list1.add(this.thirdPartyRoleToTppRole(thirdPartyRole));
        }
        return list1;
    }

    protected TppInfo thirdPartyInfoToTppInfo(ThirdPartyInfo thirdPartyInfo) {
        if (thirdPartyInfo == null) {
            return null;
        }
        TppInfo tppInfo = new TppInfo();
        tppInfo.setAuthorisationNumber(thirdPartyInfo.getAuthorisationNumber());
        tppInfo.setTppName(thirdPartyInfo.getTppName());
        tppInfo.setTppRoles(this.thirdPartyRoleListToTppRoleList(thirdPartyInfo.getTppRoles()));
        tppInfo.setAuthorityId(thirdPartyInfo.getAuthorityId());
        tppInfo.setAuthorityName(thirdPartyInfo.getAuthorityName());
        tppInfo.setCountry(thirdPartyInfo.getCountry());
        tppInfo.setOrganisation(thirdPartyInfo.getOrganisation());
        tppInfo.setOrganisationUnit(thirdPartyInfo.getOrganisationUnit());
        tppInfo.setCity(thirdPartyInfo.getCity());
        tppInfo.setState(thirdPartyInfo.getState());
        tppInfo.setCancelTppRedirectUri(this.toTppRedirectUti(thirdPartyInfo.getCancelTppRedirectUri()));
        tppInfo.setIssuerCN(thirdPartyInfo.getIssuerCN());
        return tppInfo;
    }

    protected List<AccountInfo> userAccountInfoListToAccountInfoList(List<UserAccountInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountInfo> list1 = new ArrayList<AccountInfo>(list.size());
        for (UserAccountInfo userAccountInfo : list) {
            list1.add(this.toAccountInfo(userAccountInfo));
        }
        return list1;
    }

    protected AccountAccessType userAccountAccessTypeToAccountAccessType(UserAccountAccessType userAccountAccessType) {
        AccountAccessType accountAccessType;
        if (userAccountAccessType == null) {
            return null;
        }
        switch (userAccountAccessType) {
            case ALL_ACCOUNTS: {
                accountAccessType = AccountAccessType.ALL_ACCOUNTS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + userAccountAccessType);
            }
        }
        return accountAccessType;
    }
}

