/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.cms.impl.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentResponse;
import de.adorsys.psd2.consent.service.AisConsentServiceInternal;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AisConsent;
import de.adorsys.psd2.sandbox.tpp.cms.api.service.ConsentService;
import de.adorsys.psd2.sandbox.tpp.cms.impl.mapper.AisConsentMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsentServiceImpl
implements ConsentService {
    private static final Logger log = LoggerFactory.getLogger(ConsentServiceImpl.class);
    private final AisConsentServiceInternal aisConsentServiceInternal;
    private final AisConsentMapper aisConsentMapper;

    @Transactional
    public List<String> generateConsents(List<AisConsent> consents) {
        List<String> consentIds = consents.stream().map(this.aisConsentMapper::toCmsAisConsentRequest).map(request -> {
            try {
                return this.aisConsentServiceInternal.createConsent(request);
            }
            catch (WrongChecksumException e) {
                log.error("Could not create Consent: {}", (Object)request.getInternalRequestId());
                return null;
            }
        }).filter(Objects::nonNull).map(CmsResponse::getPayload).map(CreateAisConsentResponse::getConsentId).collect(Collectors.toList());
        this.updateConsentsStatus(consentIds);
        return consentIds;
    }

    private void updateConsentsStatus(List<String> consentIds) {
        consentIds.forEach(id -> {
            try {
                this.aisConsentServiceInternal.updateConsentStatusById(id, ConsentStatus.VALID);
            }
            catch (WrongChecksumException e) {
                log.error("Could not update Consent: {} with status: {}", id, (Object)ConsentStatus.VALID.name());
            }
        });
    }

    public ConsentServiceImpl(AisConsentServiceInternal aisConsentServiceInternal, AisConsentMapper aisConsentMapper) {
        this.aisConsentServiceInternal = aisConsentServiceInternal;
        this.aisConsentMapper = aisConsentMapper;
    }
}

