/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.iban4j.CountryCode;
import org.iban4j.bban.BbanEntryType;
import org.iban4j.bban.BbanStructure;
import org.iban4j.bban.BbanStructureEntry;

public class BankCodeStructure {
    @JsonIgnore
    private final CountryCode countryCode;
    private int length;
    private BbanStructureEntry.EntryCharacterType type;

    public BankCodeStructure(CountryCode countryCode) {
        this.countryCode = countryCode;
        this.length = BbanStructure.forCountry((CountryCode)countryCode).getEntries().stream().filter(e -> e.getEntryType().equals((Object)BbanEntryType.bank_code)).findFirst().map(BbanStructureEntry::getLength).orElse(0);
        this.type = BbanStructure.forCountry((CountryCode)countryCode).getEntries().stream().filter(e -> e.getEntryType() == BbanEntryType.bank_code).findFirst().map(BbanStructureEntry::getCharacterType).orElseThrow(() -> new IllegalArgumentException("Can't define character type"));
    }

    @JsonIgnore
    public boolean isCharacterType() {
        return BbanStructureEntry.EntryCharacterType.n == this.getType();
    }

    @JsonIgnore
    public boolean isNotCharacterType() {
        return !this.isCharacterType();
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public int getLength() {
        return this.length;
    }

    public BbanStructureEntry.EntryCharacterType getType() {
        return this.type;
    }
}

