/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.resource;

import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"TPP Users management"})
public interface TppUsersRestApi {
    public static final String BASE_PATH = "/tpp/users";

    @ApiOperation(value="Create users for a given TPP", notes="Endpoint to create a user for a given TPP", authorizations={@Authorization(value="apiKey")})
    @PostMapping
    public ResponseEntity<UserTO> createUser(@RequestBody User var1);

    @ApiOperation(value="List users for a given TPP", notes="Endpoint to lists users for a given TPP", authorizations={@Authorization(value="apiKey")})
    @GetMapping
    public ResponseEntity<CustomPageImpl<UserTO>> getAllUsers(@RequestParam(required=false, defaultValue="") String var1, @RequestParam(required=false, defaultValue="0") int var2, @RequestParam(required=false, defaultValue="25") int var3);

    @ApiOperation(value="Update user for a given TPP", notes="Endpoint to update a user for a given TPP", authorizations={@Authorization(value="apiKey")})
    @PutMapping
    public ResponseEntity<Void> updateUser(@RequestBody User var1);

    @ApiOperation(value="Retrieves user by id", notes="Endpoint to get user by id", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/{userId}"})
    public ResponseEntity<UserTO> getUser(@PathVariable String var1);

    @ApiOperation(value="Get current user", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/me"})
    public ResponseEntity<UserTO> getSelf();
}

