/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.spi.domain.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum SpiAccountStatus {
    ENABLED("enabled"),
    DELETED("deleted"),
    BLOCKED("blocked");

    private static final Map<String, SpiAccountStatus> container;
    private String value;

    @JsonCreator
    private SpiAccountStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public static Optional<SpiAccountStatus> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        container = new HashMap<String, SpiAccountStatus>();
        for (SpiAccountStatus accountStatus : SpiAccountStatus.values()) {
            container.put(accountStatus.getValue(), accountStatus);
        }
    }
}

