/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.spi.domain.account;

import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpiTransactionReport {
    public static final String RESPONSE_TYPE_JSON = "application/json";
    public static final String RESPONSE_TYPE_XML = "application/xml";
    public static final String RESPONSE_TYPE_TEXT = "text/plain";
    private final String downloadId;
    private final List<SpiTransaction> transactions;
    @Nullable
    private final List<SpiAccountBalance> balances;
    @NotNull
    private final String responseContentType;
    private final byte[] transactionsRaw;

    @ConstructorProperties(value={"downloadId", "transactions", "balances", "responseContentType", "transactionsRaw"})
    public SpiTransactionReport(String downloadId, List<SpiTransaction> transactions, @Nullable List<SpiAccountBalance> balances, @NotNull String responseContentType, byte[] transactionsRaw) {
        if (responseContentType == null) {
            throw new NullPointerException("responseContentType is marked @NonNull but is null");
        }
        this.downloadId = downloadId;
        this.transactions = transactions;
        this.balances = balances;
        this.responseContentType = responseContentType;
        this.transactionsRaw = transactionsRaw;
    }

    public String getDownloadId() {
        return this.downloadId;
    }

    public List<SpiTransaction> getTransactions() {
        return this.transactions;
    }

    @Nullable
    public List<SpiAccountBalance> getBalances() {
        return this.balances;
    }

    @NotNull
    public String getResponseContentType() {
        return this.responseContentType;
    }

    public byte[] getTransactionsRaw() {
        return this.transactionsRaw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpiTransactionReport)) {
            return false;
        }
        SpiTransactionReport other = (SpiTransactionReport)o;
        String this$downloadId = this.getDownloadId();
        String other$downloadId = other.getDownloadId();
        if (this$downloadId == null ? other$downloadId != null : !this$downloadId.equals(other$downloadId)) {
            return false;
        }
        List<SpiTransaction> this$transactions = this.getTransactions();
        List<SpiTransaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        List<SpiAccountBalance> this$balances = this.getBalances();
        List<SpiAccountBalance> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        String this$responseContentType = this.getResponseContentType();
        String other$responseContentType = other.getResponseContentType();
        if (this$responseContentType == null ? other$responseContentType != null : !this$responseContentType.equals(other$responseContentType)) {
            return false;
        }
        return Arrays.equals(this.getTransactionsRaw(), other.getTransactionsRaw());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $downloadId = this.getDownloadId();
        result = result * 59 + ($downloadId == null ? 43 : $downloadId.hashCode());
        List<SpiTransaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        List<SpiAccountBalance> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        String $responseContentType = this.getResponseContentType();
        result = result * 59 + ($responseContentType == null ? 43 : $responseContentType.hashCode());
        result = result * 59 + Arrays.hashCode(this.getTransactionsRaw());
        return result;
    }

    public String toString() {
        return "SpiTransactionReport(downloadId=" + this.getDownloadId() + ", transactions=" + this.getTransactions() + ", balances=" + this.getBalances() + ", responseContentType=" + this.getResponseContentType() + ", transactionsRaw=" + Arrays.toString(this.getTransactionsRaw()) + ")";
    }
}

