/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.spi.domain.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum SpiUsageType {
    PRIV("PRIV"),
    ORGA("ORGA");

    private static final Map<String, SpiUsageType> container;
    private String value;

    @JsonCreator
    private SpiUsageType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public static Optional<SpiUsageType> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        container = new HashMap<String, SpiUsageType>();
        for (SpiUsageType usageType : SpiUsageType.values()) {
            container.put(usageType.getValue(), usageType);
        }
    }
}

