/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.spi.domain.response;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public final class SpiResponse<T> {
    private static final VoidResponse VOID_RESPONSE = new VoidResponse();
    private final T payload;
    @NotNull
    private final List<TppMessage> errors = new ArrayList<TppMessage>();

    private SpiResponse(SpiResponseBuilder<T> builder) {
        this.payload = ((SpiResponseBuilder)builder).payload;
        this.errors.addAll(((SpiResponseBuilder)builder).errors);
    }

    public static VoidResponse voidResponse() {
        return VOID_RESPONSE;
    }

    public static <T> SpiResponseBuilder<T> builder() {
        return new SpiResponseBuilder();
    }

    public boolean hasError() {
        return !this.errors.isEmpty() || this.payload == null;
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty() && this.payload != null;
    }

    public T getPayload() {
        return this.payload;
    }

    @NotNull
    public List<TppMessage> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpiResponse)) {
            return false;
        }
        SpiResponse other = (SpiResponse)o;
        T this$payload = this.getPayload();
        T other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        List<TppMessage> this$errors = this.getErrors();
        List<TppMessage> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        List<TppMessage> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "SpiResponse(payload=" + this.getPayload() + ", errors=" + this.getErrors() + ")";
    }

    public static class VoidResponse {
        private VoidResponse() {
        }
    }

    public static class SpiResponseBuilder<T> {
        private T payload;
        private List<TppMessage> errors = new ArrayList<TppMessage>();

        private SpiResponseBuilder() {
        }

        public SpiResponseBuilder<T> payload(T payload) {
            this.payload = payload;
            return this;
        }

        public SpiResponseBuilder<T> error(@NotNull TppMessage error) {
            this.errors.add(error);
            return this;
        }

        public SpiResponseBuilder<T> error(List<TppMessage> errors) {
            if (CollectionUtils.isNotEmpty(errors)) {
                this.errors.addAll(errors);
            }
            return this;
        }

        public SpiResponse<T> build() {
            if (this.payload == null && CollectionUtils.isEmpty(this.errors)) {
                this.error(new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, new Object[0]));
            }
            return new SpiResponse(this);
        }
    }
}

