/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.adapter.BaseOauth2Service;
import de.adorsys.xs2a.adapter.adapter.CertificateSubjectClientIdOauth2Service;
import de.adorsys.xs2a.adapter.adapter.PkceOauth2Service;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.http.UriBuilder;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.PkceOauth2Extension;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import de.adorsys.xs2a.adapter.validation.ValidationError;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ComdirectOauth2Service
extends AbstractService
implements Oauth2Service,
PkceOauth2Extension {
    private static final String SCA_OAUTH_LINK_MISSING_ERROR_MESSAGE = "SCA OAuth link is missing or has a wrong format: it has to be either provided as a request parameter or preconfigured for the current ASPSP";
    private final Oauth2Service oauth2Service;
    private final String baseUrl;
    private final Aspsp aspsp;

    private ComdirectOauth2Service(Oauth2Service oauth2Service, String baseUrl, Aspsp aspsp, HttpClient httpClient) {
        super(httpClient);
        this.oauth2Service = oauth2Service;
        this.baseUrl = baseUrl;
        this.aspsp = aspsp;
    }

    public static ComdirectOauth2Service create(Aspsp aspsp, HttpClient httpClient, Pkcs12KeyStore keyStore) {
        String baseUrl = aspsp.getIdpUrl() != null ? aspsp.getIdpUrl() : aspsp.getUrl();
        BaseOauth2Service baseOauth2Service = new BaseOauth2Service(aspsp, httpClient);
        CertificateSubjectClientIdOauth2Service clientIdOauth2Service = new CertificateSubjectClientIdOauth2Service((Oauth2Service)baseOauth2Service, keyStore);
        return new ComdirectOauth2Service((Oauth2Service)new PkceOauth2Service((Oauth2Service)clientIdOauth2Service), baseUrl, aspsp, httpClient);
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        this.requireValid(this.validateGetAuthorizationRequestUri(headers, parameters));
        parameters.setAuthorizationEndpoint(parameters.removeScaOAuthLink());
        return UriBuilder.fromUri((URI)this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).queryParam("scope", this.scope(parameters)).build();
    }

    public List<ValidationError> validateGetAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>(this.oauth2Service.validateGetAuthorizationRequestUri(headers, parameters));
        if (StringUtils.isBlank((CharSequence)this.getScaOAuthUrl(parameters))) {
            validationErrors.add(new ValidationError(ValidationError.Code.REQUIRED, "sca_oauth_link", SCA_OAUTH_LINK_MISSING_ERROR_MESSAGE));
        }
        return Collections.unmodifiableList(validationErrors);
    }

    private String scope(Oauth2Service.Parameters parameters) {
        if (parameters.getConsentId() != null) {
            return "AIS:" + parameters.getConsentId();
        }
        return null;
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        parameters.removeScaOAuthLink();
        parameters.setTokenEndpoint(StringUri.fromElements((String[])new String[]{this.baseUrl, "/v1/token"}));
        return this.oauth2Service.getToken(headers, parameters);
    }

    private String getScaOAuthUrl(Oauth2Service.Parameters parameters) {
        String baseScaOAuthUrl = parameters.getScaOAuthLink();
        if (StringUtils.isBlank((CharSequence)baseScaOAuthUrl)) {
            baseScaOAuthUrl = this.aspsp.getIdpUrl();
        }
        return baseScaOAuthUrl;
    }
}

