/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.service.PsuPasswordEncryptionService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.PsuData;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DeutscheBankAccountInformationService
extends BaseAccountInformationService {
    private static final String DATE_HEADER = "Date";
    private final PsuPasswordEncryptionService psuPasswordEncryptionService;

    public DeutscheBankAccountInformationService(Aspsp aspsp, HttpClient httpClient, Request.Builder.Interceptor interceptor, LinksRewriter linksRewriter, PsuPasswordEncryptionService psuPasswordEncryptionService) {
        super(aspsp, httpClient, interceptor);
        this.psuPasswordEncryptionService = psuPasswordEncryptionService;
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        PsuData psuData = updatePsuAuthentication.getPsuData();
        if (this.passwordEncryptionRequired(psuData)) {
            this.encryptPassword(psuData);
        }
        return super.startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication);
    }

    public Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        PsuData psuData = updatePsuAuthentication.getPsuData();
        if (this.passwordEncryptionRequired(psuData)) {
            this.encryptPassword(psuData);
        }
        return super.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication);
    }

    private boolean passwordEncryptionRequired(PsuData psuData) {
        return StringUtils.isNotBlank((CharSequence)psuData.getEncryptedPassword());
    }

    private void encryptPassword(PsuData psuData) {
        String password = psuData.getEncryptedPassword();
        String encryptedPassword = this.psuPasswordEncryptionService.encrypt(password);
        psuData.setEncryptedPassword(encryptedPassword);
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> map) {
        Map headers = super.populateGetHeaders(map);
        headers.put(DATE_HEADER, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        headers.put("Accept", "application/json");
        return headers;
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> map) {
        map.put(DATE_HEADER, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        map.put("Content-Type", "application/json");
        return map;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        headers.put(DATE_HEADER, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

