/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BasePaymentInitiationService;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class DeutscheBankPaymentInitiationService
extends BasePaymentInitiationService {
    private static final String DATE_HEADER = "Date";

    public DeutscheBankPaymentInitiationService(String baseUri, HttpClient httpClient, Request.Builder.Interceptor interceptor, LinksRewriter linksRewriter) {
        super(baseUri, httpClient, interceptor, linksRewriter);
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> map) {
        Map headers = super.populateGetHeaders(map);
        headers.put(DATE_HEADER, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        headers.put("Accept", "application/json");
        return headers;
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> map) {
        Map headers = super.populatePostHeaders(map);
        headers.put(DATE_HEADER, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        headers.put("Content-Type", "application/json");
        return headers;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        headers.put(DATE_HEADER, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

