/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64;
import de.adorsys.xs2a.adapter.service.PsuPasswordEncryptionService;
import de.adorsys.xs2a.adapter.service.exception.PsuPasswordEncodingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;

public class DeutscheBankPsuPasswordEncryptionService
implements PsuPasswordEncryptionService {
    private static final String URL_TO_CERTIFICATE = "https://xs2a.db.com/pb/aspsp-certificates/tpp-pb-password_cert.pem";
    private static DeutscheBankPsuPasswordEncryptionService encryptionService;
    private JWEHeader jweHeader;
    private JWEEncrypter jweEncrypter;

    public static DeutscheBankPsuPasswordEncryptionService getInstance() {
        if (encryptionService == null) {
            encryptionService = new DeutscheBankPsuPasswordEncryptionService();
        }
        return encryptionService;
    }

    private DeutscheBankPsuPasswordEncryptionService() {
        this.init();
    }

    public String encrypt(String password) {
        JWEObject jweObject = new JWEObject(this.jweHeader, new Payload(password));
        try {
            jweObject.encrypt(this.jweEncrypter);
        }
        catch (JOSEException e) {
            throw new PsuPasswordEncodingException("Exception during Deutsche bank adapter PSU password encryption", (Throwable)e);
        }
        return jweObject.serialize();
    }

    private void init() {
        CertificateFactory certificateFactory = new CertificateFactory();
        try {
            URI certificateUri = new URI(URL_TO_CERTIFICATE);
            Collection certificates = certificateFactory.engineGenerateCertificates(certificateUri.toURL().openStream());
            if (certificates.isEmpty()) {
                throw new PsuPasswordEncodingException("No certificates have been provided by bank for PSU password encryption");
            }
            List<X509Certificate> x509Certificates = this.toX509Certificates(certificates);
            List x509CertificateChainEncoded = x509Certificates.stream().map(this::toBase64).collect(Collectors.toList());
            this.jweHeader = new JWEHeader.Builder(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A256GCM).x509CertURL(certificateUri).x509CertChain(x509CertificateChainEncoded).build();
            this.jweEncrypter = new RSAEncrypter(RSAKey.parse((X509Certificate)this.getBankCertificate(x509Certificates)));
        }
        catch (JOSEException | IOException | URISyntaxException | CertificateException e) {
            throw new PsuPasswordEncodingException("Exception during Deutsche bank adapter PSU password encryption", e);
        }
    }

    private List<X509Certificate> toX509Certificates(Collection<Certificate> certificates) {
        return certificates.stream().map(certificate -> {
            if (!(certificate instanceof X509Certificate)) {
                throw new PsuPasswordEncodingException("Certificate provided by bank is not a X509 type");
            }
            return (X509Certificate)certificate;
        }).collect(Collectors.toList());
    }

    private Base64 toBase64(X509Certificate certificate) {
        try {
            return Base64.encode((byte[])certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new PsuPasswordEncodingException("Exception during Deutsche bank adapter PSU password encryption", (Throwable)e);
        }
    }

    private X509Certificate getBankCertificate(List<X509Certificate> certificates) {
        return certificates.get(0);
    }
}

