/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.http.Request;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PsuIdTypeHeaderInterceptor
implements Request.Builder.Interceptor {
    public Request.Builder apply(Request.Builder builder) {
        if (builder.headers().get("PSU-ID") != null && builder.headers().get("PSU-ID-Type") == null) {
            this.setPsuIdType(builder);
        }
        return builder;
    }

    private void setPsuIdType(Request.Builder builder) {
        URI uri = URI.create(builder.uri());
        Path path = Paths.get(uri.getPath(), new String[0]);
        if (path.getNameCount() < 3) {
            return;
        }
        String countryCode = path.getName(1).toString();
        if ("DE".equals(countryCode)) {
            String businessEntity = path.getName(2).toString();
            if ("PFB".equals(businessEntity)) {
                builder.header("PSU-ID-Type", "DE_ONLB_DB");
            } else if ("Postbank".equals(businessEntity)) {
                builder.header("PSU-ID-Type", "DE_ONLB_POBA");
            } else if ("Noris".equals(businessEntity)) {
                builder.header("PSU-ID-Type", "DE_ONLB_NORIS");
            }
        }
    }
}

