/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.provider;

import de.adorsys.xs2a.adapter.adapter.BaseDownloadService;
import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.DownloadService;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.PsuPasswordEncryptionService;
import de.adorsys.xs2a.adapter.service.impl.DeutscheBankAccountInformationService;
import de.adorsys.xs2a.adapter.service.impl.DeutscheBankPaymentInitiationService;
import de.adorsys.xs2a.adapter.service.impl.DeutscheBankPsuPasswordEncryptionService;
import de.adorsys.xs2a.adapter.service.impl.PsuIdTypeHeaderInterceptor;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.provider.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.DownloadServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.PaymentInitiationServiceProvider;

public class DeutscheBankServiceProvider
implements AccountInformationServiceProvider,
PaymentInitiationServiceProvider,
DownloadServiceProvider {
    private static final String SERVICE_GROUP_PLACEHOLDER = "{Service Group}";
    private static final PsuIdTypeHeaderInterceptor psuIdTypeHeaderInterceptor = new PsuIdTypeHeaderInterceptor();
    private static final PsuPasswordEncryptionService psuPasswordEncryptionService = DeutscheBankPsuPasswordEncryptionService.getInstance();

    public AccountInformationService getAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        aspsp.setUrl(aspsp.getUrl().replace(SERVICE_GROUP_PLACEHOLDER, "ais"));
        return new DeutscheBankAccountInformationService(aspsp, httpClientFactory.getHttpClient(this.getAdapterId()), psuIdTypeHeaderInterceptor, linksRewriter, psuPasswordEncryptionService);
    }

    public PaymentInitiationService getPaymentInitiationService(String baseUrl, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new DeutscheBankPaymentInitiationService(baseUrl.replace(SERVICE_GROUP_PLACEHOLDER, "pis"), httpClientFactory.getHttpClient(this.getAdapterId()), psuIdTypeHeaderInterceptor, linksRewriter);
    }

    public DownloadService getDownloadService(String baseUrl, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore) {
        return new BaseDownloadService(baseUrl, httpClientFactory.getHttpClient(this.getAdapterId()));
    }

    public String getAdapterId() {
        return "deutsche-bank-adapter";
    }
}

