/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.fiducia.mapper;

import de.adorsys.xs2a.adapter.fiducia.mapper.FiduciaResponseMapper;
import de.adorsys.xs2a.adapter.fiducia.model.FiduciaChallengeData;
import de.adorsys.xs2a.adapter.fiducia.model.FiduciaStartScaProcessResponse;
import de.adorsys.xs2a.adapter.fiducia.model.FiduciaUpdatePsuDataResponse;
import de.adorsys.xs2a.adapter.service.model.AuthenticationObject;
import de.adorsys.xs2a.adapter.service.model.ChallengeData;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FiduciaResponseMapperImpl
implements FiduciaResponseMapper {
    @Override
    public SelectPsuAuthenticationMethodResponse toSelectPsuAuthenticationMethodResponse(FiduciaUpdatePsuDataResponse value) {
        if (value == null) {
            return null;
        }
        SelectPsuAuthenticationMethodResponse selectPsuAuthenticationMethodResponse = new SelectPsuAuthenticationMethodResponse();
        selectPsuAuthenticationMethodResponse.setScaStatus(value.getScaStatus());
        selectPsuAuthenticationMethodResponse.setChosenScaMethod(value.getChosenScaMethod());
        selectPsuAuthenticationMethodResponse.setChallengeData(this.fiduciaChallengeDataToChallengeData(value.getChallengeData()));
        Map<String, Link> map = value.getLinks();
        if (map != null) {
            selectPsuAuthenticationMethodResponse.setLinks(new HashMap<String, Link>(map));
        }
        selectPsuAuthenticationMethodResponse.setPsuMessage(value.getPsuMessage());
        return selectPsuAuthenticationMethodResponse;
    }

    @Override
    public StartScaProcessResponse toStartScaProcessResponse(FiduciaStartScaProcessResponse value) {
        if (value == null) {
            return null;
        }
        StartScaProcessResponse startScaProcessResponse = new StartScaProcessResponse();
        startScaProcessResponse.setScaStatus(value.getScaStatus());
        startScaProcessResponse.setAuthorisationId(value.getAuthorisationId());
        List<AuthenticationObject> list = value.getScaMethods();
        if (list != null) {
            startScaProcessResponse.setScaMethods(new ArrayList<AuthenticationObject>(list));
        }
        startScaProcessResponse.setChosenScaMethod(value.getChosenScaMethod());
        startScaProcessResponse.setChallengeData(this.fiduciaChallengeDataToChallengeData(value.getChallengeData()));
        Map<String, Link> map = value.getLinks();
        if (map != null) {
            startScaProcessResponse.setLinks(new HashMap<String, Link>(map));
        }
        startScaProcessResponse.setPsuMessage(value.getPsuMessage());
        return startScaProcessResponse;
    }

    protected ChallengeData fiduciaChallengeDataToChallengeData(FiduciaChallengeData fiduciaChallengeData) {
        if (fiduciaChallengeData == null) {
            return null;
        }
        ChallengeData challengeData = new ChallengeData();
        byte[] image = fiduciaChallengeData.getImage();
        if (image != null) {
            challengeData.setImage(Arrays.copyOf(image, image.length));
        }
        challengeData.setData(this.toListOfStrings(fiduciaChallengeData.getData()));
        challengeData.setImageLink(fiduciaChallengeData.getImageLink());
        challengeData.setOtpMaxLength(fiduciaChallengeData.getOtpMaxLength());
        challengeData.setOtpFormat(fiduciaChallengeData.getOtpFormat());
        challengeData.setAdditionalInformation(fiduciaChallengeData.getAdditionalInformation());
        return challengeData;
    }
}

