/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.fiducia.mapper.FiduciaResponseMapper;
import de.adorsys.xs2a.adapter.fiducia.model.FiduciaStartScaProcessResponse;
import de.adorsys.xs2a.adapter.fiducia.model.FiduciaUpdatePsuDataResponse;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.validation.ValidationError;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.factory.Mappers;

public class FiduciaAccountInformationService
extends BaseAccountInformationService {
    private static final Set<String> SUPPORTED_BOOKING_STATUSES = new HashSet<String>(Collections.singletonList("booked"));
    private static final String BOOKING_STATUS_ERROR_MESSAGE = String.format("ASPSP supports only the following booking statuses: %s. The booking status from the request has to be changed to the supported ones.", SUPPORTED_BOOKING_STATUSES);
    private static final FiduciaResponseMapper responseMapper = (FiduciaResponseMapper)Mappers.getMapper(FiduciaResponseMapper.class);

    public FiduciaAccountInformationService(Aspsp aspsp, HttpClient httpClient, Request.Builder.Interceptor requestBuilderInterceptor, LinksRewriter linksRewriter) {
        super(aspsp, httpClient, requestBuilderInterceptor, linksRewriter);
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> headers) {
        headers.put("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        return headers;
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> headers) {
        headers.put("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        return headers;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        headers.put("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        return headers;
    }

    protected Map<String, String> populateDeleteHeaders(Map<String, String> headers) {
        headers.put("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        return headers;
    }

    public Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body) {
        this.modifyRecurringIndicator(body);
        return super.createConsent(requestHeaders, requestParams, body);
    }

    private void modifyRecurringIndicator(Consents body) {
        body.setRecurringIndicator(Boolean.valueOf(true));
    }

    public Response<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionList(accountId, requestHeaders, requestParams);
    }

    public List<ValidationError> validateGetTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.validateBookingStatus(requestParams);
    }

    private List<ValidationError> validateBookingStatus(RequestParams requestParams) {
        if (this.notSupportedBookingStatus(requestParams)) {
            return Collections.singletonList(new ValidationError(ValidationError.Code.NOT_SUPPORTED, "bookingStatus", BOOKING_STATUS_ERROR_MESSAGE));
        }
        return Collections.emptyList();
    }

    private boolean notSupportedBookingStatus(RequestParams requestParams) {
        String bookingStatus = (String)requestParams.toMap().get("bookingStatus");
        return bookingStatus != null && !SUPPORTED_BOOKING_STATUSES.contains(bookingStatus);
    }

    public List<ValidationError> validateGetTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.validateBookingStatus(requestParams);
    }

    public Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return super.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod, FiduciaUpdatePsuDataResponse.class, responseMapper::toSelectPsuAuthenticationMethodResponse);
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return super.startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication, FiduciaStartScaProcessResponse.class, responseMapper::toStartScaProcessResponse);
    }
}

