/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing;

import de.adorsys.xs2a.adapter.service.exception.BadRequestException;
import java.util.Map;
import java.util.TreeMap;

class Headers {
    private static final String BEARER_ = "Bearer ";
    private Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    Headers(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public String getAccessToken() {
        String authorization = this.headers.get("Authorization");
        if (authorization == null || !authorization.startsWith(BEARER_)) {
            throw new BadRequestException("Authorization header value must have type \"Bearer\"");
        }
        return authorization.substring(BEARER_.length());
    }

    public String getRequestId() {
        return this.headers.get("X-Request-ID");
    }
}

