/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing;

import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Account;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AccountLinks;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AccountReferenceIban;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AccountsResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Balance;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.BalancesResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.CounterpartyAccount;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.LinksNext;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Transaction;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TransactionRemittanceInformationStructured;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TransactionsResponse;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountReference;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper
public interface IngMapper {
    public AccountList map(AccountsResponse var1);

    public ReadAccountBalanceResponse map(BalancesResponse var1);

    @Mappings(value={@Mapping(target="balances", ignore=true), @Mapping(target="links", ignore=true)})
    public de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse map(TransactionsResponse var1);

    default public String map(UUID value) {
        return value.toString();
    }

    default public Map<String, HrefType> map(AccountLinks value) {
        if (value == null) {
            return null;
        }
        HashMap<String, HrefType> links = new HashMap<String, HrefType>();
        if (value.getBalances() != null) {
            links.put("balances", new HrefType(value.getBalances().getHref()));
        }
        if (value.getTransactions() != null) {
            links.put("transactions", new HrefType(value.getTransactions().getHref()));
        }
        return links;
    }

    default public String map(TransactionRemittanceInformationStructured value) {
        return value.getReference();
    }

    default public Map<String, HrefType> map(LinksNext value) {
        if (value == null) {
            return null;
        }
        if (value.getNext() != null) {
            return Collections.singletonMap("next", new HrefType(value.getNext().getHref()));
        }
        return Collections.emptyMap();
    }

    @Mappings(value={@Mapping(target="bban", ignore=true), @Mapping(target="pan", ignore=true), @Mapping(target="maskedPan", ignore=true), @Mapping(target="msisdn", ignore=true)})
    public AccountReference map(AccountReferenceIban var1);

    @Mappings(value={@Mapping(target="bban", ignore=true), @Mapping(target="msisdn", ignore=true), @Mapping(target="product", ignore=true), @Mapping(target="cashAccountType", ignore=true), @Mapping(target="status", ignore=true), @Mapping(target="bic", ignore=true), @Mapping(target="linkedAccounts", ignore=true), @Mapping(target="usage", ignore=true), @Mapping(target="details", ignore=true), @Mapping(target="balances", ignore=true)})
    public AccountDetails map(Account var1);

    @Mappings(value={@Mapping(target="creditLimitIncluded", ignore=true), @Mapping(target="lastCommittedTransaction", ignore=true)})
    public de.adorsys.xs2a.adapter.service.psd2.model.Balance map(Balance var1);

    @Mappings(value={@Mapping(target="pan", ignore=true), @Mapping(target="maskedPan", ignore=true), @Mapping(target="msisdn", ignore=true), @Mapping(target="currency", ignore=true)})
    public AccountReference map(CounterpartyAccount var1);

    @Mappings(value={@Mapping(target="entryReference", ignore=true), @Mapping(target="mandateId", ignore=true), @Mapping(target="checkId", ignore=true), @Mapping(target="creditorId", ignore=true), @Mapping(target="currencyExchange", ignore=true), @Mapping(target="ultimateCreditor", ignore=true), @Mapping(target="ultimateDebtor", ignore=true), @Mapping(target="additionalInformation", ignore=true), @Mapping(target="purposeCode", ignore=true), @Mapping(target="bankTransactionCode", ignore=true), @Mapping(target="proprietaryBankTransactionCode", ignore=true), @Mapping(target="links", ignore=true)})
    public TransactionDetails map(Transaction var1);

    public de.adorsys.xs2a.adapter.service.model.TokenResponse map(TokenResponse var1);

    public Map<String, HrefType> mapToPsd2Links(Map<String, Link> var1);

    public Map<String, Link> mapToXs2aLinks(Map<String, HrefType> var1);
}

