/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing;

import de.adorsys.xs2a.adapter.service.ing.IngMapper;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Account;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AccountReferenceIban;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AccountsResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Amount;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Balance;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.BalancesResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.CounterpartyAccount;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Transaction;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TransactionRemittanceInformationStructured;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.Transactions;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TransactionsResponse;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountReference;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountReport;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.RemittanceInformationStructured;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IngMapperImpl
implements IngMapper {
    @Override
    public AccountList map(AccountsResponse value) {
        if (value == null) {
            return null;
        }
        AccountList accountList = new AccountList();
        accountList.setAccounts(this.accountListToAccountDetailsList(value.getAccounts()));
        return accountList;
    }

    @Override
    public ReadAccountBalanceResponse map(BalancesResponse value) {
        if (value == null) {
            return null;
        }
        ReadAccountBalanceResponse readAccountBalanceResponse = new ReadAccountBalanceResponse();
        readAccountBalanceResponse.setAccount(this.map(value.getAccount()));
        readAccountBalanceResponse.setBalances(this.balanceListToBalanceList(value.getBalances()));
        return readAccountBalanceResponse;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse map(TransactionsResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse transactionsResponse = new de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse();
        transactionsResponse.setAccount(this.map(value.getAccount()));
        transactionsResponse.setTransactions(this.transactionsToAccountReport(value.getTransactions()));
        return transactionsResponse;
    }

    @Override
    public AccountReference map(AccountReferenceIban value) {
        if (value == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(value.getIban());
        accountReference.setCurrency(value.getCurrency());
        return accountReference;
    }

    @Override
    public AccountDetails map(Account value) {
        if (value == null) {
            return null;
        }
        AccountDetails accountDetails = new AccountDetails();
        accountDetails.setResourceId(this.map(value.getResourceId()));
        accountDetails.setIban(value.getIban());
        accountDetails.setCurrency(value.getCurrency());
        accountDetails.setName(value.getName());
        accountDetails.setLinks(this.map(value.getLinks()));
        return accountDetails;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.psd2.model.Balance map(Balance value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.Balance balance = new de.adorsys.xs2a.adapter.service.psd2.model.Balance();
        balance.setBalanceAmount(this.amountToAmount(value.getBalanceAmount()));
        balance.setBalanceType(value.getBalanceType());
        balance.setLastChangeDateTime(value.getLastChangeDateTime());
        balance.setReferenceDate(value.getReferenceDate());
        return balance;
    }

    @Override
    public AccountReference map(CounterpartyAccount value) {
        if (value == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(value.getIban());
        accountReference.setBban(value.getBban());
        return accountReference;
    }

    @Override
    public TransactionDetails map(Transaction value) {
        if (value == null) {
            return null;
        }
        TransactionDetails transactionDetails = new TransactionDetails();
        transactionDetails.setTransactionId(value.getTransactionId());
        transactionDetails.setEndToEndId(value.getEndToEndId());
        transactionDetails.setBookingDate(value.getBookingDate());
        transactionDetails.setValueDate(value.getValueDate());
        transactionDetails.setTransactionAmount(this.amountToAmount(value.getTransactionAmount()));
        transactionDetails.setCreditorName(value.getCreditorName());
        transactionDetails.setCreditorAccount(this.map(value.getCreditorAccount()));
        transactionDetails.setDebtorName(value.getDebtorName());
        transactionDetails.setDebtorAccount(this.map(value.getDebtorAccount()));
        transactionDetails.setRemittanceInformationUnstructured(value.getRemittanceInformationUnstructured());
        transactionDetails.setRemittanceInformationStructured(this.transactionRemittanceInformationStructuredToRemittanceInformationStructured(value.getRemittanceInformationStructured()));
        return transactionDetails;
    }

    @Override
    public de.adorsys.xs2a.adapter.service.model.TokenResponse map(TokenResponse value) {
        if (value == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.model.TokenResponse tokenResponse = new de.adorsys.xs2a.adapter.service.model.TokenResponse();
        tokenResponse.setAccessToken(value.getAccessToken());
        tokenResponse.setTokenType(value.getTokenType());
        tokenResponse.setExpiresInSeconds(value.getExpiresInSeconds());
        tokenResponse.setRefreshToken(value.getRefreshToken());
        tokenResponse.setScope(value.getScope());
        return tokenResponse;
    }

    @Override
    public Map<String, HrefType> mapToPsd2Links(Map<String, Link> links) {
        if (links == null) {
            return null;
        }
        HashMap<String, HrefType> map = new HashMap<String, HrefType>(Math.max((int)((float)links.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, Link> entry : links.entrySet()) {
            String key = entry.getKey();
            HrefType value = this.linkToHrefType(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<String, Link> mapToXs2aLinks(Map<String, HrefType> links) {
        if (links == null) {
            return null;
        }
        HashMap<String, Link> map = new HashMap<String, Link>(Math.max((int)((float)links.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, HrefType> entry : links.entrySet()) {
            String key = entry.getKey();
            Link value = this.hrefTypeToLink(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    protected List<AccountDetails> accountListToAccountDetailsList(List<Account> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountDetails> list1 = new ArrayList<AccountDetails>(list.size());
        for (Account account : list) {
            list1.add(this.map(account));
        }
        return list1;
    }

    protected List<de.adorsys.xs2a.adapter.service.psd2.model.Balance> balanceListToBalanceList(List<Balance> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.Balance> list1 = new ArrayList<de.adorsys.xs2a.adapter.service.psd2.model.Balance>(list.size());
        for (Balance balance : list) {
            list1.add(this.map(balance));
        }
        return list1;
    }

    protected List<TransactionDetails> transactionListToTransactionDetailsList(List<Transaction> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TransactionDetails> list1 = new ArrayList<TransactionDetails>(list.size());
        for (Transaction transaction : list) {
            list1.add(this.map(transaction));
        }
        return list1;
    }

    protected AccountReport transactionsToAccountReport(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        AccountReport accountReport = new AccountReport();
        accountReport.setBooked(this.transactionListToTransactionDetailsList(transactions.getBooked()));
        accountReport.setPending(this.transactionListToTransactionDetailsList(transactions.getPending()));
        accountReport.setLinks(this.map(transactions.getLinks()));
        return accountReport;
    }

    protected de.adorsys.xs2a.adapter.service.psd2.model.Amount amountToAmount(Amount amount) {
        if (amount == null) {
            return null;
        }
        de.adorsys.xs2a.adapter.service.psd2.model.Amount amount1 = new de.adorsys.xs2a.adapter.service.psd2.model.Amount();
        amount1.setCurrency(amount.getCurrency());
        if (amount.getAmount() != null) {
            amount1.setAmount(String.valueOf(amount.getAmount()));
        }
        return amount1;
    }

    protected RemittanceInformationStructured transactionRemittanceInformationStructuredToRemittanceInformationStructured(TransactionRemittanceInformationStructured transactionRemittanceInformationStructured) {
        if (transactionRemittanceInformationStructured == null) {
            return null;
        }
        RemittanceInformationStructured remittanceInformationStructured = new RemittanceInformationStructured();
        remittanceInformationStructured.setReference(transactionRemittanceInformationStructured.getReference());
        remittanceInformationStructured.setReferenceType(transactionRemittanceInformationStructured.getReferenceType());
        remittanceInformationStructured.setReferenceIssuer(transactionRemittanceInformationStructured.getReferenceIssuer());
        return remittanceInformationStructured;
    }

    protected HrefType linkToHrefType(Link link) {
        if (link == null) {
            return null;
        }
        HrefType hrefType = new HrefType();
        hrefType.setHref(link.getHref());
        return hrefType;
    }

    protected Link hrefTypeToLink(HrefType hrefType) {
        if (hrefType == null) {
            return null;
        }
        Link link = new Link();
        link.setHref(hrefType.getHref());
        return link;
    }
}

