/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ResponseHeaders;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import de.adorsys.xs2a.adapter.service.ing.Headers;
import de.adorsys.xs2a.adapter.service.ing.IngMapper;
import de.adorsys.xs2a.adapter.service.ing.QueryParameters;
import de.adorsys.xs2a.adapter.service.ing.internal.api.AccountInformationApi;
import de.adorsys.xs2a.adapter.service.ing.internal.api.ClientAuthentication;
import de.adorsys.xs2a.adapter.service.ing.internal.api.ClientAuthenticationFactory;
import de.adorsys.xs2a.adapter.service.ing.internal.api.Oauth2Api;
import de.adorsys.xs2a.adapter.service.ing.internal.service.IngOauth2Service;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.model.AccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountDetailsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountList;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountReport;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountsTransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentInformationResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.Consents;
import de.adorsys.xs2a.adapter.service.psd2.model.ConsentsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.HrefType;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ReadCardAccountBalanceResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionDetails;
import de.adorsys.xs2a.adapter.service.psd2.model.TransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisation;
import de.adorsys.xs2a.adapter.service.psd2.model.UpdateAuthorisationResponse;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;

public class IngPsd2AccountInformationService
implements Psd2AccountInformationService,
Oauth2Service {
    private final IngOauth2Service oauth2Service;
    private final AccountInformationApi accountInformationApi;
    private final LinksRewriter linksRewriter;
    private final IngMapper mapper = (IngMapper)Mappers.getMapper(IngMapper.class);

    public IngPsd2AccountInformationService(String baseUri, HttpClient httpClient, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) throws GeneralSecurityException {
        this.linksRewriter = linksRewriter;
        this.accountInformationApi = new AccountInformationApi(baseUri, httpClient);
        Oauth2Api oauth2Api = new Oauth2Api(baseUri, httpClient);
        String qsealAlias = AdapterConfig.readProperty((String)"ing.qseal.alias");
        X509Certificate qsealCertificate = keyStore.getQsealCertificate(qsealAlias);
        PrivateKey qsealPrivateKey = keyStore.getQsealPrivateKey(qsealAlias);
        ClientAuthenticationFactory clientAuthenticationFactory = new ClientAuthenticationFactory(qsealCertificate, qsealPrivateKey);
        this.oauth2Service = new IngOauth2Service(oauth2Api, clientAuthenticationFactory);
    }

    public Response<ConsentsResponse> createConsent(Map<String, String> queryParameters, Map<String, String> headers, Consents consents) {
        return this.toResponse(new ConsentsResponse());
    }

    private <T> Response<T> toResponse(T body) {
        return new Response(200, body, ResponseHeaders.fromMap(Collections.emptyMap()));
    }

    public Response<ConsentInformationResponse> getConsentInformation(String consentId, Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<Void> deleteConsent(String consentId, Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<CardAccountList> getCardAccountList(Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<CardAccountDetailsResponse> getCardAccountDetails(String accountId, Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<ReadCardAccountBalanceResponse> getCardAccountBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException();
    }

    public Response<CardAccountsTransactionsResponse> getCardAccountTransactionList(String accountId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.getCardAccountTransactionList(accountId, new QueryParameters(queryParameters), new Headers(headers));
    }

    private Response<CardAccountsTransactionsResponse> getCardAccountTransactionList(String accountId, QueryParameters queryParameters, Headers headers) {
        Integer limit;
        LocalDate dateTo;
        String accessToken = headers.getAccessToken();
        ClientAuthentication clientAuthentication = this.oauth2Service.getClientAuthentication(accessToken);
        LocalDate dateFrom = queryParameters.getDateFrom();
        Response<CardAccountsTransactionsResponse> response = this.accountInformationApi.getCardAccountTransactions(accountId, dateFrom, dateTo = queryParameters.getDateTo(), limit = queryParameters.getLimit(), headers.getRequestId(), clientAuthentication);
        CardAccountsTransactionsResponse body = (CardAccountsTransactionsResponse)response.getBody();
        if (body != null) {
            body.setLinks(this.rewriteLinks(body.getLinks()));
            CardAccountReport cardTransactions = body.getCardTransactions();
            if (cardTransactions != null) {
                cardTransactions.setLinks(this.rewriteLinks(cardTransactions.getLinks()));
            }
        }
        return response;
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation updateAuthentication) {
        throw new UnsupportedOperationException();
    }

    public Response<UpdateAuthorisationResponse> updateConsentsPsuData(String consentId, String authorisationId, Map<String, String> queryParameters, Map<String, String> headers, UpdateAuthorisation updateAuthentication) {
        throw new UnsupportedOperationException();
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        return this.oauth2Service.getAuthorizationRequestUri(parameters);
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        return this.mapper.map(this.oauth2Service.getToken(parameters));
    }

    public Response<AccountList> getAccounts(Map<String, String> queryParameters, Map<String, String> headers) {
        return this.getAccounts(new Headers(headers));
    }

    private Response<AccountList> getAccounts(Headers headers) {
        ClientAuthentication clientAuthentication = this.oauth2Service.getClientAuthentication(headers.getAccessToken());
        Response response = this.accountInformationApi.getAccounts(headers.getRequestId(), clientAuthentication).map(this.mapper::map);
        this.rewriteLinks((AccountList)response.getBody());
        return response;
    }

    private void rewriteLinks(AccountList accountList) {
        Optional.ofNullable(accountList).map(AccountList::getAccounts).ifPresent(accounts -> accounts.forEach(acc -> acc.setLinks(this.rewriteLinks(acc.getLinks()))));
    }

    private Map<String, HrefType> rewriteLinks(Map<String, HrefType> links) {
        Map<String, Link> xs2aLinks = this.mapper.mapToXs2aLinks(links);
        Map rewrittenLinks = this.linksRewriter.rewrite(xs2aLinks);
        return this.mapper.mapToPsd2Links(rewrittenLinks);
    }

    public Response<ReadAccountBalanceResponse> getBalances(String accountId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.getBalances(accountId, new QueryParameters(queryParameters), new Headers(headers));
    }

    private Response<ReadAccountBalanceResponse> getBalances(String accountId, QueryParameters queryParameters, Headers headers) {
        String accessToken = headers.getAccessToken();
        ClientAuthentication clientAuthentication = this.oauth2Service.getClientAuthentication(accessToken);
        Currency currency = queryParameters.getCurrency();
        List balanceTypes = queryParameters.get("balanceTypes", this::parseBalanceTypes);
        return this.accountInformationApi.getBalances(accountId, balanceTypes, currency, headers.getRequestId(), clientAuthentication).map(this.mapper::map);
    }

    private List<String> parseBalanceTypes(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(value.split(",")).collect(Collectors.toList());
    }

    public Response<TransactionsResponse> getTransactions(String accountId, Map<String, String> queryParameters, Map<String, String> headers) {
        return this.getTransactions(accountId, new QueryParameters(queryParameters), new Headers(headers));
    }

    private Response<TransactionsResponse> getTransactions(String accountId, QueryParameters queryParameters, Headers headers) {
        String accessToken = headers.getAccessToken();
        ClientAuthentication clientAuthentication = this.oauth2Service.getClientAuthentication(accessToken);
        LocalDate dateFrom = queryParameters.getDateFrom();
        LocalDate dateTo = queryParameters.getDateTo();
        Currency currency = queryParameters.getCurrency();
        Integer limit = queryParameters.getLimit();
        Response response = this.accountInformationApi.getTransactions(accountId, dateFrom, dateTo, currency, limit, headers.getRequestId(), clientAuthentication).map(this.mapper::map);
        this.rewriteLinks((TransactionsResponse)response.getBody());
        return response;
    }

    private void rewriteLinks(TransactionsResponse transactionsResponse) {
        Optional.ofNullable(transactionsResponse).ifPresent(body -> {
            body.setLinks(this.rewriteLinks(body.getLinks()));
            Optional.ofNullable(body.getTransactions()).ifPresent(ts -> {
                ts.setLinks(this.rewriteLinks(ts.getLinks()));
                this.rewriteLinks(ts.getBooked());
                this.rewriteLinks(ts.getPending());
            });
        });
    }

    private void rewriteLinks(List<TransactionDetails> transactionDetails) {
        Optional.ofNullable(transactionDetails).ifPresent(td -> td.forEach(t -> t.setLinks(this.rewriteLinks(t.getLinks()))));
    }
}

