/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing;

import de.adorsys.xs2a.adapter.adapter.link.identity.IdentityLinksRewriter;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Oauth2ServiceFactory;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import de.adorsys.xs2a.adapter.service.ing.IngPsd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationService;
import de.adorsys.xs2a.adapter.service.psd2.Psd2AccountInformationServiceFactory;
import java.security.GeneralSecurityException;

public class IngServiceFactory
implements Psd2AccountInformationServiceFactory,
Oauth2ServiceFactory {
    private static final LinksRewriter DEFAULT_LINKS_REWRITER = new IdentityLinksRewriter();

    public Psd2AccountInformationService getAccountInformationService(String baseUrl, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return this.getIngPsd2AccountInformationService(baseUrl, httpClientFactory, keyStore, linksRewriter);
    }

    private IngPsd2AccountInformationService getIngPsd2AccountInformationService(String baseUrl, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        HttpClient httpClient = httpClientFactory.getHttpClient(this.getAdapterId(), AdapterConfig.readProperty((String)"ing.qwac.alias"));
        try {
            return new IngPsd2AccountInformationService(baseUrl, httpClient, keyStore, linksRewriter);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Oauth2Service getOauth2Service(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore) {
        String baseUrl = aspsp.getIdpUrl() != null ? aspsp.getIdpUrl() : aspsp.getUrl();
        return this.getIngPsd2AccountInformationService(baseUrl, httpClientFactory, keyStore, DEFAULT_LINKS_REWRITER);
    }

    public String getAdapterId() {
        return "ing-adapter";
    }
}

