/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing.internal.api;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AccountsResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.BalancesResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TransactionsResponse;
import de.adorsys.xs2a.adapter.service.psd2.model.CardAccountsTransactionsResponse;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class AccountInformationApi {
    private static final String ACCOUNTS_ENDPOINT = "/v3/accounts";
    private static final String TRANSACTIONS_ENDPOINT = "/v2/accounts/{{accountId}}/transactions";
    private static final String BALANCES_ENDPOINT = "/v3/accounts/{{accountId}}/balances";
    private static final String CARD_ACCOUNT_TRANSACTIONS_ENDPOINT = "/v1/card-accounts/{{accountId}}/transactions";
    private final String baseUri;
    private final HttpClient httpClient;

    public AccountInformationApi(String baseUri, HttpClient httpClient) {
        this.baseUri = baseUri;
        this.httpClient = httpClient;
    }

    public Response<AccountsResponse> getAccounts(String requestId, Request.Builder.Interceptor clientAuthentication) {
        return this.httpClient.get(this.baseUri + ACCOUNTS_ENDPOINT).header("X-Request-ID", requestId).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(AccountsResponse.class));
    }

    public Response<TransactionsResponse> getTransactions(String resourceId, LocalDate dateFrom, LocalDate dateTo, Currency currency, Integer limit, String requestId, Request.Builder.Interceptor clientAuthentication) {
        LinkedHashMap<String, Serializable> queryParams = new LinkedHashMap<String, Serializable>();
        queryParams.put("dateFrom", dateFrom);
        queryParams.put("dateTo", dateTo);
        queryParams.put("currency", currency);
        queryParams.put("limit", limit);
        String uri = StringUri.withQuery((String)(this.baseUri + TRANSACTIONS_ENDPOINT.replace("{{accountId}}", Objects.requireNonNull(resourceId))), queryParams);
        return this.httpClient.get(uri).header("X-Request-ID", requestId).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(TransactionsResponse.class));
    }

    public Response<BalancesResponse> getBalances(String resourceId, List<String> balanceTypes, Currency currency, String requestId, Request.Builder.Interceptor clientAuthentication) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        queryParams.put("balanceTypes", balanceTypes == null ? null : String.join((CharSequence)",", balanceTypes));
        queryParams.put("currency", currency);
        String uri = StringUri.withQuery((String)(this.baseUri + BALANCES_ENDPOINT.replace("{{accountId}}", Objects.requireNonNull(resourceId))), queryParams);
        return this.httpClient.get(uri).header("X-Request-ID", requestId).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(BalancesResponse.class));
    }

    public Response<CardAccountsTransactionsResponse> getCardAccountTransactions(String accountId, LocalDate dateFrom, LocalDate dateTo, Integer limit, String requestId, Request.Builder.Interceptor clientAuthentication) {
        LinkedHashMap<String, Comparable<ChronoLocalDate>> queryParams = new LinkedHashMap<String, Comparable<ChronoLocalDate>>();
        queryParams.put("dateFrom", dateFrom);
        queryParams.put("dateTo", dateTo);
        queryParams.put("limit", limit);
        String uri = StringUri.withQuery((String)(this.baseUri + CARD_ACCOUNT_TRANSACTIONS_ENDPOINT.replace("{{accountId}}", Objects.requireNonNull(accountId))), queryParams);
        return this.httpClient.get(uri).header("X-Request-ID", requestId).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(CardAccountsTransactionsResponse.class));
    }
}

