/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing.internal.api;

import de.adorsys.xs2a.adapter.service.ing.internal.api.ClientAuthentication;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.ApplicationTokenResponse;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.security.auth.x500.X500Principal;

public class ClientAuthenticationFactory {
    private final Signature signature = Signature.getInstance("SHA256withRSA");
    private final MessageDigest digest;
    private final String tppSignatureCertificate;
    private final String keyId;

    public ClientAuthenticationFactory(X509Certificate certificate, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CertificateEncodingException {
        this.signature.initSign(privateKey);
        this.digest = MessageDigest.getInstance("SHA-256");
        this.tppSignatureCertificate = this.base64(certificate.getEncoded());
        this.keyId = this.keyId(certificate);
    }

    private String keyId(X509Certificate certificate) {
        return "SN=" + certificate.getSerialNumber().toString(16) + ",CA=" + this.issuerNameRfc2253(certificate);
    }

    private String issuerNameRfc2253(X509Certificate qSealCertificate) {
        X500Principal issuerX500Principal = qSealCertificate.getIssuerX500Principal();
        return issuerX500Principal.getName("RFC2253");
    }

    private String base64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public ClientAuthentication newClientAuthenticationForApplicationToken() {
        return new ClientAuthentication(this.signature, this.digest, this.tppSignatureCertificate, this.keyId, null);
    }

    public ClientAuthentication newClientAuthentication(ApplicationTokenResponse applicationToken) {
        return new ClientAuthentication(this.signature, this.digest, this.tppSignatureCertificate, applicationToken.getClientId(), applicationToken.getAccessToken());
    }

    public ClientAuthentication newClientAuthentication(ApplicationTokenResponse applicationToken, String accessToken) {
        return new ClientAuthentication(this.signature, this.digest, this.tppSignatureCertificate, applicationToken.getClientId(), accessToken);
    }
}

