/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing.internal.api;

import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.ApplicationTokenResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AuthorizationURLResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TokenResponse;
import java.util.Collections;
import java.util.Map;

public class Oauth2Api {
    private static final String TOKEN_ENDPOINT = "/oauth2/token";
    private static final String AUTHORIZATION_ENDPOINT = "/oauth2/authorization-server-url";
    private final String baseUri;
    private final HttpClient httpClient;

    public Oauth2Api(String baseUri, HttpClient httpClient) {
        this.baseUri = baseUri;
        this.httpClient = httpClient;
    }

    public Response<ApplicationTokenResponse> getApplicationToken(Request.Builder.Interceptor clientAuthentication) {
        return this.httpClient.post(this.baseUri + TOKEN_ENDPOINT).urlEncodedBody(Collections.singletonMap("grant_type", "client_credentials")).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(ApplicationTokenResponse.class));
    }

    public Response<TokenResponse> getCustomerToken(Oauth2Service.Parameters parameters, Request.Builder.Interceptor clientAuthentication) {
        return this.httpClient.post(this.baseUri + TOKEN_ENDPOINT).urlEncodedBody(parameters.asMap()).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(TokenResponse.class));
    }

    public Response<AuthorizationURLResponse> getAuthorizationUrl(Request.Builder.Interceptor clientAuthentication, String scope, String redirectUri) {
        Oauth2Service.Parameters queryParameters = new Oauth2Service.Parameters();
        queryParameters.setScope(scope);
        queryParameters.setRedirectUri(redirectUri);
        String uri = StringUri.withQuery((String)(this.baseUri + AUTHORIZATION_ENDPOINT), (Map)queryParameters.asMap());
        return this.httpClient.get(uri).send(clientAuthentication, ResponseHandlers.jsonResponseHandler(AuthorizationURLResponse.class));
    }
}

