/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing.internal.service;

import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.ing.internal.api.ClientAuthentication;
import de.adorsys.xs2a.adapter.service.ing.internal.api.ClientAuthenticationFactory;
import de.adorsys.xs2a.adapter.service.ing.internal.api.Oauth2Api;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.ApplicationTokenResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.AuthorizationURLResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.api.model.TokenResponse;
import de.adorsys.xs2a.adapter.service.ing.internal.service.ParametersValidationService;
import java.net.URI;
import java.util.Map;

public class IngOauth2Service {
    private final Oauth2Api oauth2Api;
    private final ClientAuthenticationFactory clientAuthenticationFactory;
    private ApplicationTokenResponse applicationToken;

    public IngOauth2Service(Oauth2Api oauth2Api, ClientAuthenticationFactory clientAuthenticationFactory) {
        this.oauth2Api = oauth2Api;
        this.clientAuthenticationFactory = clientAuthenticationFactory;
    }

    public URI getAuthorizationRequestUri(Oauth2Service.Parameters parameters) {
        ParametersValidationService.validateScope(parameters);
        ClientAuthentication clientAuthentication = this.clientAuthenticationFactory.newClientAuthentication(this.getApplicationToken());
        AuthorizationURLResponse authorizationUrlResponse = (AuthorizationURLResponse)this.oauth2Api.getAuthorizationUrl(clientAuthentication, parameters.getScope(), parameters.getRedirectUri()).getBody();
        parameters.setClientId(this.getClientId());
        parameters.setResponseType(Oauth2Service.ResponseType.CODE.toString());
        return URI.create(StringUri.withQuery((String)authorizationUrlResponse.getLocation(), (Map)parameters.asMap()));
    }

    private ApplicationTokenResponse getApplicationToken() {
        if (this.applicationToken != null) {
            return this.applicationToken;
        }
        ClientAuthentication clientAuthentication = this.clientAuthenticationFactory.newClientAuthenticationForApplicationToken();
        this.applicationToken = (ApplicationTokenResponse)this.oauth2Api.getApplicationToken(clientAuthentication).getBody();
        return this.applicationToken;
    }

    private String getClientId() {
        return this.getApplicationToken().getClientId();
    }

    public TokenResponse getToken(Oauth2Service.Parameters parameters) {
        ClientAuthentication clientAuthentication = this.clientAuthenticationFactory.newClientAuthentication(this.getApplicationToken());
        return (TokenResponse)this.oauth2Api.getCustomerToken(parameters, clientAuthentication).getBody();
    }

    public ClientAuthentication getClientAuthentication(String accessToken) {
        return this.clientAuthenticationFactory.newClientAuthentication(this.getApplicationToken(), accessToken);
    }
}

