/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.ing.internal.service;

import de.adorsys.xs2a.adapter.service.Oauth2Service;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParametersValidationService {
    private static final String DEFAULT_SCOPE = "payment-accounts:transactions:view";
    private static final Set<String> availableScopes = new HashSet<String>(Arrays.asList("payment-accounts:transactions:view", "payment-accounts:balances:view"));

    public static Oauth2Service.Parameters validateScope(Oauth2Service.Parameters params) {
        if (StringUtils.isBlank((CharSequence)params.get("scope"))) {
            params.set("scope", DEFAULT_SCOPE);
            return params;
        }
        if (!ParametersValidationService.hasAvailableScopes(params)) {
            List<String> listOfInputScopes = ParametersValidationService.scopesAsList(params);
            String outputScopes = listOfInputScopes.stream().filter(availableScopes::contains).collect(Collectors.joining(" "));
            params.set("scope", StringUtils.isBlank((CharSequence)outputScopes) ? DEFAULT_SCOPE : outputScopes);
            return params;
        }
        return params;
    }

    private static boolean hasAvailableScopes(Oauth2Service.Parameters params) {
        List<String> listOfScopes = ParametersValidationService.scopesAsList(params);
        return availableScopes.containsAll(listOfScopes);
    }

    private static List<String> scopesAsList(Oauth2Service.Parameters params) {
        return Arrays.asList(params.getScope().split("\\s+"));
    }
}

