/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.JsonMapper;
import de.adorsys.xs2a.adapter.security.AccessTokenException;
import de.adorsys.xs2a.adapter.security.AccessTokenService;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SantanderAccessTokenService
implements AccessTokenService {
    private static final Logger logger = LoggerFactory.getLogger(SantanderAccessTokenService.class);
    public static final String SANTANDER_TOKEN_CONSUMER_KEY_PROPERTY = "santander.token.consumer_key";
    private static final String SANTANDER_TOKEN_CONSUMER_SECRET_PROPERTY = "santander.token.consumer_secret";
    private static final String SANTANDER_TOKEN_URL_PROPERTY = "santander.token.url";
    private static final String SANTANDER_TOKEN_SECONDS_BEFORE_TOKEN_EXPIRATION_PROPERTY = "santander.token.seconds_before_token_expiration";
    private static final String DEFAULT_SECONDS_BEFORE_TOKEN_EXPIRATION = "60";
    private static final String DEFAULT_TOKEN_URL = "https://apigateway-sandbox.api.santander.de/scb-openapis/sx/oauthsos/password/token";
    private static SantanderAccessTokenService instance = new SantanderAccessTokenService();
    private static Map<String, String> headers;
    private static String tokenUrl;
    private static int secondsBeforeTokenExpiration;
    private HttpClient httpClient;
    private AccessToken accessToken;
    private JsonMapper jsonMapper = new JsonMapper();

    private SantanderAccessTokenService() {
    }

    public static SantanderAccessTokenService getInstance() {
        return instance;
    }

    public String retrieveToken() {
        if (this.isNotValid()) {
            logger.debug("Token is not valid");
            Response response = this.httpClient.post(tokenUrl).urlEncodedBody(Collections.singletonMap("grant_type", "client_credentials")).headers(headers).send(this.responseHandler());
            logger.debug("New token is retrieved");
            this.accessToken = new AccessToken((TokenResponse)response.getBody());
        }
        return this.accessToken.token;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private boolean isNotValid() {
        if (this.accessToken == null || this.accessToken.token == null || this.accessToken.validity == null) {
            return true;
        }
        LocalDateTime expirationDate = LocalDateTime.now().plusSeconds(secondsBeforeTokenExpiration);
        return this.accessToken.validity.isBefore(expirationDate);
    }

    private HttpClient.ResponseHandler<TokenResponse> responseHandler() {
        return (statusCode, responseBody, responseHeaders) -> {
            if (statusCode == 200) {
                return (TokenResponse)this.jsonMapper.readValue(responseBody, TokenResponse.class);
            }
            String message = "Can't retrieve access token by provided credentials";
            logger.error(message);
            throw new AccessTokenException(message);
        };
    }

    private static String buildBasicAuthorization(String key, String secret) {
        String credentials = key + ":" + secret;
        return new String(Base64.getEncoder().encode(credentials.getBytes()));
    }

    static {
        String consumerKey = AdapterConfig.readProperty((String)SANTANDER_TOKEN_CONSUMER_KEY_PROPERTY, (String)"");
        String consumerSecret = AdapterConfig.readProperty((String)SANTANDER_TOKEN_CONSUMER_SECRET_PROPERTY, (String)"");
        if (consumerKey.isEmpty() || consumerSecret.isEmpty()) {
            String message = "Consumer key or secret are not provided";
            logger.error(message);
            throw new AccessTokenException(message);
        }
        headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + SantanderAccessTokenService.buildBasicAuthorization(consumerKey, consumerSecret));
        tokenUrl = AdapterConfig.readProperty((String)SANTANDER_TOKEN_URL_PROPERTY, (String)DEFAULT_TOKEN_URL);
        logger.debug("Token url is {}", (Object)tokenUrl);
        secondsBeforeTokenExpiration = Integer.parseInt(AdapterConfig.readProperty((String)SANTANDER_TOKEN_SECONDS_BEFORE_TOKEN_EXPIRATION_PROPERTY, (String)DEFAULT_SECONDS_BEFORE_TOKEN_EXPIRATION));
        logger.debug("Seconds before token expiration is {}", (Object)secondsBeforeTokenExpiration);
    }

    private static class AccessToken {
        private String token;
        private LocalDateTime validity;

        AccessToken(TokenResponse response) {
            this.token = response.accessToken;
            this.validity = LocalDateTime.now().plusSeconds(response.expiresIn);
        }
    }

    static class TokenResponse {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="token_type")
        private String tokenType;
        @JsonProperty(value="expires_in")
        private int expiresIn;
        private String scope;

        TokenResponse() {
        }

        TokenResponse(String accessToken, String tokenType, int expiresIn, String scope) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            this.expiresIn = expiresIn;
            this.scope = scope;
        }
    }
}

