/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.security.AccessTokenService;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SantanderAccountInformationService
extends BaseAccountInformationService {
    private static final Set<String> HEADERS_TO_KEEP = new HashSet<String>(Arrays.asList("X-Request-ID", "Accept", "Content-Type", "Consent-ID"));
    private AccessTokenService accessService;

    public SantanderAccountInformationService(Aspsp aspsp, AccessTokenService accessService, HttpClient httpClient, LinksRewriter linksRewriter) {
        super(aspsp, httpClient, linksRewriter);
        this.accessService = accessService;
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> headers) {
        return this.updateHeaders(headers);
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        return this.updateHeaders(headers);
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> headers) {
        return this.updateHeaders(headers);
    }

    protected Map<String, String> populateDeleteHeaders(Map<String, String> headers) {
        return this.updateHeaders(headers);
    }

    private Map<String, String> updateHeaders(Map<String, String> headers) {
        this.removeUnneededHeaders(headers);
        this.addBearerHeader(headers);
        this.addIbmClientIdHeader(headers);
        return headers;
    }

    private void removeUnneededHeaders(Map<String, String> headers) {
        headers.keySet().removeIf(header -> !HEADERS_TO_KEEP.contains(header));
    }

    private void addBearerHeader(Map<String, String> headers) {
        headers.put("Authorization", "Bearer " + this.accessService.retrieveToken());
    }

    private void addIbmClientIdHeader(Map<String, String> headers) {
        headers.put("x-ibm-client-id", this.getConsumerKey());
    }

    private String getConsumerKey() {
        return AdapterConfig.readProperty((String)"santander.token.consumer_key", (String)"");
    }
}

