/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.adapter.BaseOauth2Service;
import de.adorsys.xs2a.adapter.adapter.CertificateSubjectClientIdOauth2Service;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.http.UriBuilder;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.PkceOauth2Extension;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.SpardaPkceOauth2Service;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import de.adorsys.xs2a.adapter.validation.ValidationError;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SpardaOauth2Service
extends AbstractService
implements Oauth2Service,
PkceOauth2Extension {
    private static final String MISSING_REQUIRED_PARAMETER_ERROR_MESSAGE = "Missing required parameter";
    private final Aspsp aspsp;
    private final Oauth2Service oauth2Service;
    private final String clientId;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;

    private SpardaOauth2Service(Aspsp aspsp, HttpClient httpClient, Oauth2Service oauth2Service, String clientId) {
        super(httpClient);
        this.aspsp = aspsp;
        this.oauth2Service = oauth2Service;
        this.clientId = clientId;
        String[] idpHosts = Objects.requireNonNull(aspsp.getIdpUrl()).trim().split("\\s+");
        if (idpHosts.length != 2) {
            throw new IllegalArgumentException("IDP must consist of two hosts separated by a whitespace");
        }
        this.authorizationEndpoint = StringUri.fromElements((String[])new String[]{idpHosts[0], "/oauth2/authorize"});
        this.tokenEndpoint = StringUri.fromElements((String[])new String[]{idpHosts[1], "/oauth2/token"});
    }

    public static SpardaOauth2Service create(Aspsp aspsp, HttpClient httpClient, Pkcs12KeyStore keyStore, String clientId) {
        BaseOauth2Service baseOauth2Service = new BaseOauth2Service(aspsp, httpClient);
        CertificateSubjectClientIdOauth2Service clientIdOauth2Service = new CertificateSubjectClientIdOauth2Service((Oauth2Service)baseOauth2Service, keyStore);
        SpardaPkceOauth2Service pkceOauth2Service = new SpardaPkceOauth2Service((Oauth2Service)clientIdOauth2Service);
        return new SpardaOauth2Service(aspsp, httpClient, (Oauth2Service)pkceOauth2Service, clientId);
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        this.requireValid(this.validateGetAuthorizationRequestUri(headers, parameters));
        parameters.setAuthorizationEndpoint(this.authorizationEndpoint);
        parameters.setClientId(this.clientId);
        if (StringUtils.isBlank((CharSequence)parameters.getScope())) {
            parameters.setScope("ais");
        }
        return UriBuilder.fromUri((URI)this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).queryParam("bic", this.aspsp.getBic()).build();
    }

    public List<ValidationError> validateGetAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        if (StringUtils.isBlank((CharSequence)parameters.getRedirectUri())) {
            return Collections.singletonList(new ValidationError(ValidationError.Code.REQUIRED, "redirect_uri", MISSING_REQUIRED_PARAMETER_ERROR_MESSAGE));
        }
        return Collections.emptyList();
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        this.requireValid(this.validateGetToken(headers, parameters));
        parameters.setClientId(this.clientId);
        parameters.setTokenEndpoint(this.tokenEndpoint);
        return this.oauth2Service.getToken(headers, parameters);
    }

    public List<ValidationError> validateGetToken(Map<String, String> headers, Oauth2Service.Parameters parameters) {
        if (parameters.getAuthorizationCode() != null && StringUtils.isBlank((CharSequence)parameters.getRedirectUri())) {
            return Collections.singletonList(new ValidationError(ValidationError.Code.REQUIRED, "redirect_uri", MISSING_REQUIRED_PARAMETER_ERROR_MESSAGE));
        }
        return Collections.emptyList();
    }

    public byte[] octetSequence() {
        return SpardaPkceOauth2Service.OCTET_SEQUENCE;
    }
}

