/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.validation.ValidationError;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnicreditAccountInformationService
extends BaseAccountInformationService {
    private static final String REDIRECT_URI_ERROR = "TPP-Redirect-URI header is missing. It must be provided for this request";
    private static final String DEFAULT_PSU_ID_TYPE = "HVB_ONLINEBANKING";
    private static final Set<String> POSSIBLE_PSU_ID_TYPE_VALUES = new HashSet<String>(Arrays.asList("HVB_ONLINEBANKING", "UCEBANKINGGLOBAL"));

    public UnicreditAccountInformationService(Aspsp aspsp, HttpClient httpClient, LinksRewriter linksRewriter) {
        super(aspsp, httpClient, linksRewriter);
    }

    public Response<AccountListHolder> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getAccountList(requestHeaders, RequestParams.builder().build());
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> map) {
        map.put("Content-Type", "application/json");
        return map;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        headers.put("Content-Type", "application/json");
        return headers;
    }

    protected Map<String, String> addPsuIdTypeHeader(Map<String, String> headers) {
        if (!POSSIBLE_PSU_ID_TYPE_VALUES.contains(headers.get("PSU-ID-Type"))) {
            headers.put("PSU-ID-Type", DEFAULT_PSU_ID_TYPE);
        }
        return headers;
    }

    public List<ValidationError> validateCreateConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body) {
        return this.requireTppRedirectUri(requestHeaders);
    }

    private List<ValidationError> requireTppRedirectUri(RequestHeaders requestHeaders) {
        if (!requestHeaders.get("TPP-Redirect-URI").isPresent()) {
            return Collections.singletonList(new ValidationError(ValidationError.Code.REQUIRED, "TPP-Redirect-URI", REDIRECT_URI_ERROR));
        }
        return Collections.emptyList();
    }

    public List<ValidationError> validateStartConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.requireTppRedirectUri(requestHeaders);
    }

    public List<ValidationError> validateStartConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.requireTppRedirectUri(requestHeaders);
    }
}

