/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BasePaymentInitiationService;
import de.adorsys.xs2a.adapter.adapter.StandardPaymentProduct;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.impl.mapper.PaymentInitiationScaStatusResponseMapper;
import de.adorsys.xs2a.adapter.service.impl.mapper.ScaStatusResponseMapper;
import de.adorsys.xs2a.adapter.service.impl.mapper.UnicreditInitiateSinglePaymentResponseMapper;
import de.adorsys.xs2a.adapter.service.impl.mapper.UnicreditStartAuthorisationResponseMapper;
import de.adorsys.xs2a.adapter.service.impl.model.UnicreditPaymentScaStatusResponse;
import de.adorsys.xs2a.adapter.service.impl.model.UnicreditStartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationRequestResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationStatus;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.validation.RequestValidationException;
import de.adorsys.xs2a.adapter.validation.ValidationError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UnicreditPaymentInitiationService
extends BasePaymentInitiationService {
    private static final String AUTHENTICATION_CURRENT_NUMBER_QUERY_PARAM = "authenticationCurrentNumber";
    private static final String SINGLE_PAYMENT_PAYMENT_SERVICE = "payments";
    private final UnicreditInitiateSinglePaymentResponseMapper initiateSinglePaymentResponseMapper = new UnicreditInitiateSinglePaymentResponseMapper();
    private final UnicreditStartAuthorisationResponseMapper startAuthorisationResponseMapper = new UnicreditStartAuthorisationResponseMapper();
    private final ScaStatusResponseMapper scaStatusResponseMapper = new ScaStatusResponseMapper();
    private final PaymentInitiationScaStatusResponseMapper paymentInitiationScaStatusResponseMapper = new PaymentInitiationScaStatusResponseMapper();

    public UnicreditPaymentInitiationService(String baseUri, HttpClient httpClient, LinksRewriter linksRewriter) {
        super(baseUri, httpClient, linksRewriter);
    }

    public Response<PaymentInitiationRequestResponse> initiateSinglePayment(String paymentProduct, RequestHeaders requestHeaders, RequestParams requestParams, Object body) {
        return this.initiateSinglePayment(StandardPaymentProduct.fromSlug((String)paymentProduct), body, requestHeaders, requestParams, PaymentInitiationRequestResponse.class, this.initiateSinglePaymentResponseMapper::modifyResponse);
    }

    public Response<StartScaProcessResponse> startSinglePaymentAuthorisation(String paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        String uri = StringUri.fromElements((String[])new String[]{this.getSinglePaymentBaseUri(), paymentProduct, paymentId});
        uri = UnicreditPaymentInitiationService.buildUri((String)uri, (RequestParams)requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString((Object)updatePsuAuthentication);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(ResponseHandlers.jsonResponseHandler(UnicreditStartScaProcessResponse.class));
        return new Response(response.getStatusCode(), (Object)this.startAuthorisationResponseMapper.modifyResponse((UnicreditStartScaProcessResponse)response.getBody()), response.getHeaders());
    }

    public Response<ScaStatusResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation) {
        return this.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation, UnicreditPaymentScaStatusResponse.class, this.scaStatusResponseMapper::toScaStatusResponse);
    }

    protected String getUpdatePaymentPsuDataUri(String paymentService, String paymentProduct, String paymentId, String authorisationId) {
        String uri = StringUri.fromElements((String[])new String[]{this.getPaymentBaseUri(), paymentService, paymentProduct, paymentId});
        return StringUri.withQuery((String)uri, (String)AUTHENTICATION_CURRENT_NUMBER_QUERY_PARAM, (String)authorisationId);
    }

    public Response<PaymentInitiationScaStatusResponse> getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        List<ValidationError> validationErrors = this.validateGetPaymentInitiationScaStatus(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams);
        if (!validationErrors.isEmpty()) {
            throw new RequestValidationException(validationErrors);
        }
        Response response = this.getSinglePaymentInitiationStatus(paymentProduct, paymentId, requestHeaders, requestParams);
        return new Response(response.getStatusCode(), (Object)this.paymentInitiationScaStatusResponseMapper.toScaStatusResponse((PaymentInitiationStatus)response.getBody()), response.getHeaders());
    }

    public List<ValidationError> validateGetPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>(2);
        if (!SINGLE_PAYMENT_PAYMENT_SERVICE.equals(paymentService)) {
            errors.add(new ValidationError(ValidationError.Code.NOT_SUPPORTED, "paymentService", "'" + paymentService + "' is not a supported payment service"));
        }
        if (!requestHeaders.isAcceptJson()) {
            errors.add(new ValidationError(ValidationError.Code.NOT_SUPPORTED, "Accept", "'" + requestHeaders.get("Accept") + "' is not allowed"));
        }
        return Collections.unmodifiableList(errors);
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> map) {
        Map headers = super.populateGetHeaders(map);
        headers.put("Accept", "application/json");
        return headers;
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> map) {
        Map headers = super.populatePostHeaders(map);
        headers.put("Content-Type", "application/json");
        return headers;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

