/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl.mapper;

import de.adorsys.xs2a.adapter.service.impl.mapper.StartScaProcessResponseUnicreditMapper;
import de.adorsys.xs2a.adapter.service.impl.mapper.UnicreditResponseMapper;
import de.adorsys.xs2a.adapter.service.impl.model.UnicreditStartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.impl.service.UnicreditLinkBuilderService;
import de.adorsys.xs2a.adapter.service.model.Link;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicreditStartAuthorisationResponseMapper
implements UnicreditResponseMapper<UnicreditStartScaProcessResponse, StartScaProcessResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(UnicreditStartAuthorisationResponseMapper.class);
    private static final String SELECT_AUTHENTICATION_METHOD_LINK = "selectAuthenticationMethod";
    private static final String AUTHORISE_TRANSACTION_LINK = "authoriseTransaction";
    private static final String AUTHENTICATION_CURRENT_NUMBER_QUERY_PARAM = "authenticationCurrentNumber";
    private final StartScaProcessResponseUnicreditMapper startScaProcessResponseMapper = new StartScaProcessResponseUnicreditMapper();
    private final UnicreditLinkBuilderService linkBuilderService = new UnicreditLinkBuilderService();

    @Override
    public StartScaProcessResponse modifyResponse(UnicreditStartScaProcessResponse unicreditResponse) {
        StartScaProcessResponse startScaProcessResponse = this.startScaProcessResponseMapper.toStartScaProcessResponse(unicreditResponse);
        Map links = startScaProcessResponse.getLinks();
        if (links.containsKey(AUTHORISE_TRANSACTION_LINK) && ((Link)links.get(AUTHORISE_TRANSACTION_LINK)).getHref().contains("authenticationCurrentNumber=")) {
            if (startScaProcessResponse.isSelectScaMethodStage()) {
                this.modifyLinksToActualVersion(links, AUTHORISE_TRANSACTION_LINK, SELECT_AUTHENTICATION_METHOD_LINK, this.linkBuilderService::buildUpdatePsuDataUri);
            } else if (startScaProcessResponse.isChosenScaMethodStage()) {
                this.modifyLinksToActualVersion(links, AUTHORISE_TRANSACTION_LINK, AUTHORISE_TRANSACTION_LINK, this.linkBuilderService::buildUpdatePsuDataUri);
            } else {
                LOG.warn("Unexpected embedded authorisation stage according to the response body: {}", (Object)startScaProcessResponse);
            }
        }
        return startScaProcessResponse;
    }
}

