/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl.service;

import de.adorsys.xs2a.adapter.http.StringUri;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicreditLinkBuilderService {
    private static final Logger LOG = LoggerFactory.getLogger(UnicreditLinkBuilderService.class);
    private static final String AUTHORISATIONS = "authorisations";
    private static final String AUTHENTICATION_CURRENT_NUMBER_QUERY_PARAM = "authenticationCurrentNumber";

    public String buildStartAuthorisationUri(String uri) {
        return StringUri.fromElements((String[])new String[]{uri, AUTHORISATIONS});
    }

    public String buildUpdatePsuDataUri(String uri) {
        Map queryParams = StringUri.getQueryParamsFromUri((String)uri);
        String authenticationCurrentNumber = (String)queryParams.get(AUTHENTICATION_CURRENT_NUMBER_QUERY_PARAM);
        if (authenticationCurrentNumber == null || authenticationCurrentNumber.isEmpty()) {
            LOG.warn("Unexpected link [{}] for Unicredit: [{}] query param is not presented", (Object)uri, (Object)AUTHENTICATION_CURRENT_NUMBER_QUERY_PARAM);
            return uri;
        }
        return StringUri.fromElements((String[])new String[]{this.removeQueryParamFromUri(uri), AUTHORISATIONS, authenticationCurrentNumber});
    }

    private String removeQueryParamFromUri(String uri) {
        return uri.split("\\?")[0];
    }
}

