/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.impl;

import de.adorsys.xs2a.adapter.adapter.BaseAccountInformationService;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class VerlagAccountInformationService
extends BaseAccountInformationService {
    private static final String ACCEPT_ALL = "*/*";
    private static final String ACCEPT_XML = "application/xml";
    private AbstractMap.SimpleImmutableEntry<String, String> apiKey;

    public VerlagAccountInformationService(Aspsp aspsp, AbstractMap.SimpleImmutableEntry<String, String> apiKey, HttpClient httpClient, LinksRewriter linksRewriter) {
        super(aspsp, httpClient, linksRewriter);
        this.apiKey = apiKey;
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return super.getTransactionListAsString(accountId, this.modifyAcceptHeader(requestHeaders), requestParams);
    }

    private RequestHeaders modifyAcceptHeader(RequestHeaders requestHeaders) {
        Optional acceptHeaderOptional = requestHeaders.get("Accept");
        if (!acceptHeaderOptional.isPresent() || ((String)acceptHeaderOptional.get()).isEmpty() || ((String)acceptHeaderOptional.get()).equals(ACCEPT_ALL)) {
            requestHeaders = this.modifyAcceptHeader(requestHeaders, ACCEPT_XML);
        } else if (this.acceptHeaderIsAListOfValues((String)acceptHeaderOptional.get())) {
            String[] acceptHeaderValues = ((String)acceptHeaderOptional.get()).split(",");
            requestHeaders = this.containsXml(acceptHeaderValues) ? this.modifyAcceptHeader(requestHeaders, ACCEPT_XML) : this.modifyAcceptHeader(requestHeaders, acceptHeaderValues[0]);
        }
        return requestHeaders;
    }

    private boolean acceptHeaderIsAListOfValues(String acceptHeader) {
        return acceptHeader.contains(",");
    }

    private boolean containsXml(String[] acceptHeaderValues) {
        return Stream.of(acceptHeaderValues).anyMatch(accept -> accept.contains(ACCEPT_XML));
    }

    private RequestHeaders modifyAcceptHeader(RequestHeaders requestHeaders, String acceptHeader) {
        Map headersMap = requestHeaders.toMap();
        headersMap.put("Accept", acceptHeader);
        return RequestHeaders.fromMap((Map)headersMap);
    }

    protected Map<String, String> populatePostHeaders(Map<String, String> headers) {
        this.addApiKey(headers);
        return headers;
    }

    protected Map<String, String> populatePutHeaders(Map<String, String> headers) {
        this.addApiKey(headers);
        return headers;
    }

    protected Map<String, String> populateGetHeaders(Map<String, String> headers) {
        this.addApiKey(headers);
        return headers;
    }

    protected Map<String, String> populateDeleteHeaders(Map<String, String> headers) {
        this.addApiKey(headers);
        return headers;
    }

    private void addApiKey(Map<String, String> headers) {
        headers.put(this.apiKey.getKey(), this.apiKey.getValue());
    }
}

