/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.service.provider;

import de.adorsys.xs2a.adapter.adapter.BaseDownloadService;
import de.adorsys.xs2a.adapter.http.HttpClientFactory;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.DownloadService;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.config.AdapterConfig;
import de.adorsys.xs2a.adapter.service.impl.VerlagAccountInformationService;
import de.adorsys.xs2a.adapter.service.impl.VerlagPaymentInitiationService;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.provider.AccountInformationServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.DownloadServiceProvider;
import de.adorsys.xs2a.adapter.service.provider.PaymentInitiationServiceProvider;
import java.util.AbstractMap;

public class VerlagServiceProvider
implements AccountInformationServiceProvider,
PaymentInitiationServiceProvider,
DownloadServiceProvider {
    private static final String VERLAG_API_KEY_NAME = "verlag.apikey.name";
    private static final String VERLAG_API_KEY_VALUE = "verlag.apikey.value";
    private static final String[] SUPPORTED_CIPHER_SUITES = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"};
    private static AbstractMap.SimpleImmutableEntry<String, String> apiKeyEntry;

    public AccountInformationService getAccountInformationService(Aspsp aspsp, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new VerlagAccountInformationService(aspsp, apiKeyEntry, httpClientFactory.getHttpClient(this.getAdapterId(), null, SUPPORTED_CIPHER_SUITES), linksRewriter);
    }

    public PaymentInitiationService getPaymentInitiationService(String baseUrl, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore, LinksRewriter linksRewriter) {
        return new VerlagPaymentInitiationService(baseUrl, apiKeyEntry, httpClientFactory.getHttpClient(this.getAdapterId(), null, SUPPORTED_CIPHER_SUITES), linksRewriter);
    }

    public DownloadService getDownloadService(String baseUrl, HttpClientFactory httpClientFactory, Pkcs12KeyStore keyStore) {
        return new BaseDownloadService(baseUrl, httpClientFactory.getHttpClient(this.getAdapterId(), null, SUPPORTED_CIPHER_SUITES));
    }

    public String getAdapterId() {
        return "verlag-adapter";
    }

    static {
        String apiKeyName = AdapterConfig.readProperty((String)VERLAG_API_KEY_NAME, (String)"");
        String apiKeyValue = AdapterConfig.readProperty((String)VERLAG_API_KEY_VALUE, (String)"");
        apiKeyEntry = new AbstractMap.SimpleImmutableEntry<String, String>(apiKeyName, apiKeyValue);
    }
}

