/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.registry;

import de.adorsys.xs2a.adapter.registry.exception.RegistryIOException;
import de.adorsys.xs2a.adapter.service.AspspRepository;
import de.adorsys.xs2a.adapter.service.exception.IbanException;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.AspspScaApproach;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.iban4j.Iban;
import org.iban4j.Iban4jException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneAspspRepository
implements AspspRepository {
    private static final Logger logger = LoggerFactory.getLogger(LuceneAspspRepository.class);
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String ZERO_OR_MORE_OF_ANY_CHARS_REGEX = ".*";
    private static final float HIGH_PRIORITY = 1.5f;
    private static final float MEDIUM_PRIORITY = 1.0f;
    private static final float LOW_PRIORITY = 0.5f;
    private static final String ID_FIELD_NAME = "id";
    private static final String NAME_FIELD_NAME = "name";
    private static final String URL_FIELD_NAME = "url";
    private static final String BIC_FIELD_NAME = "bic";
    private static final String BANK_CODE_FIELD_NAME = "bankCode";
    private static final String ADAPTER_ID_FIELD_NAME = "adapterId";
    private static final String IDP_URL_FIELD_NAME = "idpUrl";
    private static final String SCA_APPROACHES_FIELD_NAME = "scaApproaches";
    private Directory directory;

    public LuceneAspspRepository(Directory directory) {
        this.directory = directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Aspsp save(Aspsp aspsp) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig();
        try (IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);){
            Aspsp aspsp2 = this.save(indexWriter, aspsp);
            return aspsp2;
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    public void deleteById(String aspspId) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig();
        try (IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);){
            indexWriter.deleteDocuments(new Term[]{new Term(ID_FIELD_NAME, aspspId)});
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    public void deleteAll() {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig();
        try (IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);){
            indexWriter.deleteAll();
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    private Aspsp save(IndexWriter indexWriter, Aspsp aspsp) throws IOException {
        Optional<Object> storedAspsp = Optional.empty();
        if (aspsp.getId() == null) {
            aspsp.setId(UUID.randomUUID().toString());
        } else {
            storedAspsp = this.findById(aspsp.getId());
        }
        Document document = new Document();
        document.add((IndexableField)new StringField(ID_FIELD_NAME, this.serialize(aspsp.getId()), Field.Store.YES));
        document.add((IndexableField)new TextField(NAME_FIELD_NAME, this.serialize(aspsp.getName()), Field.Store.YES));
        document.add((IndexableField)new StringField(URL_FIELD_NAME, this.serialize(aspsp.getUrl()), Field.Store.YES));
        document.add((IndexableField)new StringField(BIC_FIELD_NAME, this.serialize(aspsp.getBic()), Field.Store.YES));
        document.add((IndexableField)new StringField(BANK_CODE_FIELD_NAME, this.serialize(aspsp.getBankCode()), Field.Store.YES));
        document.add((IndexableField)new StringField(ADAPTER_ID_FIELD_NAME, this.serialize(aspsp.getAdapterId()), Field.Store.YES));
        document.add((IndexableField)new StringField(IDP_URL_FIELD_NAME, this.serialize(aspsp.getIdpUrl()), Field.Store.YES));
        document.add((IndexableField)new StringField(SCA_APPROACHES_FIELD_NAME, this.serialize(aspsp.getScaApproaches()), Field.Store.YES));
        if (storedAspsp.isPresent()) {
            indexWriter.updateDocument(new Term(ID_FIELD_NAME, aspsp.getId()), (Iterable)document);
        } else {
            indexWriter.addDocument((Iterable)document);
        }
        return aspsp;
    }

    private String serialize(String s) {
        return String.valueOf(s);
    }

    private <T extends Enum<T>> String serialize(List<T> data) {
        if (data == null) {
            return "null";
        }
        return data.stream().map(Enum::toString).collect(Collectors.joining(SEMICOLON_SEPARATOR));
    }

    public void saveAll(List<Aspsp> aspsps) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig();
        try (IndexWriter indexWriter = new IndexWriter(this.directory, indexWriterConfig);){
            for (Aspsp aspsp : aspsps) {
                this.save(indexWriter, aspsp);
            }
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    public Optional<Aspsp> findById(String id) {
        logger.debug("Searching for ASPSPs: by ID [{}]", (Object)id);
        List<Aspsp> aspsps = this.find((Query)new TermQuery(new Term(ID_FIELD_NAME, id)), null, 1);
        if (aspsps.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(aspsps.get(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Document> getDocument(int docId) {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            if (docId < 0 || docId >= indexReader.maxDoc()) {
                Optional<Document> optional = Optional.empty();
                return optional;
            }
            Document document = indexReader.document(docId);
            Optional<Document> optional = Optional.of(document);
            return optional;
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    private String deserialize(String s) {
        if ("null".equals(s)) {
            return null;
        }
        return s;
    }

    private <T extends Enum<T>> List<T> deserialize(String s, Class<T> klass) {
        if ("null".equals(s)) {
            return null;
        }
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        String[] values = s.split(SEMICOLON_SEPARATOR);
        return Arrays.stream(values).map(value -> Enum.valueOf(klass, value.trim().toUpperCase())).collect(Collectors.toList());
    }

    public List<Aspsp> findByBic(String bic, String after, int size) {
        logger.debug("Searching for ASPSPs: by BIC [{}]", (Object)bic);
        Query query = this.getBicQuery(bic);
        return this.find(query, after, size);
    }

    private Query getBicQuery(String bic) {
        return new PrefixQuery(new Term(BIC_FIELD_NAME, bic));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Aspsp> find(Query query, String after, int size) {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            ScoreDoc afterDoc = this.parseScoreDoc(after);
            TopDocs topDocs = indexSearcher.searchAfter(afterDoc, query, size);
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            List<Aspsp> aspsps = Arrays.stream(scoreDocs).map(this::getDocumentAsAspsp).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            logger.debug("Searching for ASPSPs: {} record(s) have been found", (Object)aspsps.size());
            List<Aspsp> list = aspsps;
            return list;
        }
        catch (IndexNotFoundException e) {
            logger.debug("Searching for ASPSPs: no records have been found");
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    private Optional<Aspsp> getDocumentAsAspsp(ScoreDoc scoreDoc) {
        return this.getDocument(scoreDoc.doc).map(document -> {
            Aspsp aspsp = new Aspsp();
            aspsp.setId(this.deserialize(document.get(ID_FIELD_NAME)));
            aspsp.setName(this.deserialize(document.get(NAME_FIELD_NAME)));
            aspsp.setUrl(this.deserialize(document.get(URL_FIELD_NAME)));
            aspsp.setBic(this.deserialize(document.get(BIC_FIELD_NAME)));
            aspsp.setBankCode(this.deserialize(document.get(BANK_CODE_FIELD_NAME)));
            aspsp.setAdapterId(this.deserialize(document.get(ADAPTER_ID_FIELD_NAME)));
            aspsp.setIdpUrl(this.deserialize(document.get(IDP_URL_FIELD_NAME)));
            aspsp.setScaApproaches(this.deserialize(document.get(SCA_APPROACHES_FIELD_NAME), AspspScaApproach.class));
            aspsp.setPaginationId(scoreDoc.doc + ":" + scoreDoc.score);
            return aspsp;
        });
    }

    private ScoreDoc parseScoreDoc(String id) {
        if (id == null) {
            return null;
        }
        String[] components = id.split(":");
        if (components.length != 2) {
            return null;
        }
        try {
            int docId = Integer.parseInt(components[0]);
            float score = Float.parseFloat(components[1]);
            return new ScoreDoc(docId, score);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List<Aspsp> findByBankCode(String bankCode, String after, int size) {
        logger.debug("Searching for ASPSPs: by bank code [{}}", (Object)bankCode);
        Query query = this.getBankCodeQuery(bankCode);
        return this.find(query, after, size);
    }

    private Query getBankCodeQuery(String bankCode) {
        return new PrefixQuery(new Term(BANK_CODE_FIELD_NAME, bankCode));
    }

    public List<Aspsp> findByName(String name, String after, int size) {
        logger.debug("Searching for ASPSPs: by name [{}]", (Object)name);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(this.getNameFuzzyQuery(name), BooleanClause.Occur.SHOULD);
        queryBuilder.add(this.getNameRegexpQuery(name), BooleanClause.Occur.SHOULD);
        return this.find((Query)queryBuilder.build(), after, size);
    }

    private Query getNameFuzzyQuery(String name) {
        return new FuzzyQuery(new Term(NAME_FIELD_NAME, name));
    }

    private Query getNameRegexpQuery(String name) {
        return new RegexpQuery(new Term(NAME_FIELD_NAME, name + ZERO_OR_MORE_OF_ANY_CHARS_REGEX));
    }

    public List<Aspsp> findAll(String after, int size) {
        logger.debug("Searching for ASPSPs: any {} records", (Object)size);
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        return this.find((Query)query, after, size);
    }

    public List<Aspsp> findLike(Aspsp aspsp, String after, int size) {
        logger.debug(this.buildFindLikeLoggingMessage(aspsp));
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        if (aspsp.getName() != null) {
            queryBuilder.add((Query)this.buildQueryWithPriority(this.getNameFuzzyQuery(aspsp.getName()), 0.5f), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)this.buildQueryWithPriority(this.getNameRegexpQuery(aspsp.getName()), 0.5f), BooleanClause.Occur.SHOULD);
        }
        if (aspsp.getBic() != null && aspsp.getBankCode() != null) {
            String bic = aspsp.getBic();
            String bankCode = aspsp.getBankCode();
            queryBuilder.add((Query)this.buildQueryWithPriority(this.getBicAndBankCodeQuery(bic, bankCode), 1.5f), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)this.buildQueryWithPriority(this.getBicAndEmptyBankCodeQuery(bic), 1.0f), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)this.buildQueryWithPriority(this.getEmptyBicAndBankCodeQuery(bankCode), 0.5f), BooleanClause.Occur.SHOULD);
        } else {
            if (aspsp.getBic() != null) {
                queryBuilder.add(this.getBicQuery(aspsp.getBic()), BooleanClause.Occur.SHOULD);
            }
            if (aspsp.getBankCode() != null) {
                queryBuilder.add(this.getBankCodeQuery(aspsp.getBankCode()), BooleanClause.Occur.SHOULD);
            }
        }
        return this.find((Query)queryBuilder.build(), after, size);
    }

    private String buildFindLikeLoggingMessage(Aspsp aspsp) {
        StringBuilder messageBuilder = new StringBuilder("Searching for ASPSPs: by");
        if (aspsp.getName() != null) {
            messageBuilder.append(" name [").append(aspsp.getName()).append("] ,");
        }
        if (aspsp.getBic() != null) {
            messageBuilder.append(" BIC [").append(aspsp.getBic()).append("] ,");
        }
        if (aspsp.getBankCode() != null) {
            messageBuilder.append(" bank code [").append(aspsp.getBankCode()).append("] ,");
        }
        return messageBuilder.toString().substring(0, messageBuilder.length() - 1);
    }

    public List<Aspsp> findByIban(String iban, String after, int size) {
        String bankCode;
        try {
            bankCode = Iban.valueOf((String)iban).getBankCode();
        }
        catch (Iban4jException e) {
            throw new IbanException((Exception)((Object)e));
        }
        if (bankCode == null) {
            throw new IbanException("Failed to extract the bank code from the iban");
        }
        return this.findByBankCode(bankCode, after, size);
    }

    private BoostQuery buildQueryWithPriority(Query query, float priority) {
        return new BoostQuery(query, priority);
    }

    private Query getBicAndBankCodeQuery(String bic, String bankCode) {
        return new BooleanQuery.Builder().add(this.getBicQuery(bic), BooleanClause.Occur.MUST).add(this.getBankCodeQuery(bankCode), BooleanClause.Occur.MUST).build();
    }

    private Query getBicAndEmptyBankCodeQuery(String bic) {
        return new BooleanQuery.Builder().add(this.getBicQuery(bic), BooleanClause.Occur.MUST).add(this.getBankCodeQuery("null"), BooleanClause.Occur.MUST).build();
    }

    private Query getEmptyBicAndBankCodeQuery(String bankCode) {
        return new BooleanQuery.Builder().add(this.getBicQuery("null"), BooleanClause.Occur.MUST).add(this.getBankCodeQuery(bankCode), BooleanClause.Occur.MUST).build();
    }
}

