/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.registry;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import de.adorsys.xs2a.adapter.registry.AspspCsvRecord;
import de.adorsys.xs2a.adapter.registry.LuceneAspspRepository;
import de.adorsys.xs2a.adapter.registry.exception.RegistryIOException;
import de.adorsys.xs2a.adapter.registry.mapper.AspspMapper;
import de.adorsys.xs2a.adapter.service.PropertyUtil;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.mapstruct.factory.Mappers;

public class LuceneAspspRepositoryFactory {
    private static final String LUCENE_DIR_PATH_PROPERTY = "csv.aspsp.adapter.lucene.dir.path";
    private static final String CSV_ASPSP_ADAPTER_CONFIG_FILE_PATH_PROPERTY = "csv.aspsp.adapter.config.file.path";
    private static final String DEFAULT_LUCENE_DIR_PATH = "lucene";
    private static final String DEFAULT_CSV_ASPSP_ADAPTER_CONFIG_FILE = "aspsp-adapter-config.csv";
    private final AspspMapper aspspMapper = (AspspMapper)Mappers.getMapper(AspspMapper.class);

    public LuceneAspspRepository newLuceneAspspRepository() {
        try {
            return this.newLuceneAspspRepositoryInternal();
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    private LuceneAspspRepository newLuceneAspspRepositoryInternal() throws IOException {
        String[] storedDigest;
        String luceneDirPath = PropertyUtil.readProperty((String)LUCENE_DIR_PATH_PROPERTY, (String)DEFAULT_LUCENE_DIR_PATH);
        FSDirectory directory = FSDirectory.open((Path)Paths.get(luceneDirPath, "index"));
        LuceneAspspRepository luceneAspspRepository = new LuceneAspspRepository((Directory)directory);
        byte[] csv = this.getCsvFileAsByteArray();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String computedDigest = new BigInteger(1, messageDigest.digest(csv)).toString(16);
        Path digestPath = Paths.get(luceneDirPath, "digest.sha256");
        boolean changed = Files.exists(digestPath, new LinkOption[0]) ? !computedDigest.equals(storedDigest = new String(Files.readAllBytes(digestPath))) : true;
        if (changed) {
            for (String f : directory.listAll()) {
                directory.deleteFile(f);
            }
            List<Aspsp> aspsps = this.readAllRecords(csv);
            luceneAspspRepository.saveAll(aspsps);
            Files.write(digestPath, computedDigest.getBytes(), new OpenOption[0]);
        }
        return luceneAspspRepository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getCsvFileAsByteArray() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        try (InputStream is = this.getCsvFileAsStream();){
            int nRead;
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
    }

    private InputStream getCsvFileAsStream() {
        String csvConfigFileProperty = PropertyUtil.readProperty((String)CSV_ASPSP_ADAPTER_CONFIG_FILE_PATH_PROPERTY);
        InputStream inputStream = csvConfigFileProperty.isEmpty() ? this.getResourceAsStream(DEFAULT_CSV_ASPSP_ADAPTER_CONFIG_FILE) : this.getFileAsStream(csvConfigFileProperty);
        return inputStream;
    }

    private InputStream getResourceAsStream(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
    }

    private InputStream getFileAsStream(String filePath) {
        try {
            return new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new RegistryIOException(e);
        }
    }

    private List<Aspsp> readAllRecords(byte[] csv) {
        List aspsps;
        ObjectReader objectReader = new CsvMapper().readerWithTypedSchemaFor(AspspCsvRecord.class).withHandler(new DeserializationProblemHandler(){

            public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) {
                if (targetType.isEnum()) {
                    return Enum.valueOf(targetType, valueToConvert.trim().toUpperCase());
                }
                return DeserializationProblemHandler.NOT_HANDLED;
            }
        });
        try {
            aspsps = objectReader.readValues(csv).readAll();
        }
        catch (IOException e) {
            throw new RegistryIOException(e);
        }
        return this.aspspMapper.toAspsps(aspsps);
    }
}

