/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.adapter.link.identity.IdentityLinksRewriter;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.AccountInformationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.AccountReport;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.BalanceReport;
import de.adorsys.xs2a.adapter.service.model.CardAccountBalanceReport;
import de.adorsys.xs2a.adapter.service.model.CardAccountDetailsHolder;
import de.adorsys.xs2a.adapter.service.model.CardAccountList;
import de.adorsys.xs2a.adapter.service.model.CardAccountReport;
import de.adorsys.xs2a.adapter.service.model.CardAccountsTransactions;
import de.adorsys.xs2a.adapter.service.model.ConsentCreationResponse;
import de.adorsys.xs2a.adapter.service.model.ConsentInformation;
import de.adorsys.xs2a.adapter.service.model.ConsentStatusResponse;
import de.adorsys.xs2a.adapter.service.model.Consents;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.TransactionDetails;
import de.adorsys.xs2a.adapter.service.model.Transactions;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAccountInformationService
extends AbstractService
implements AccountInformationService {
    private static final LinksRewriter DEFAULT_LINKS_REWRITER = new IdentityLinksRewriter();
    protected static final Logger logger = LoggerFactory.getLogger(BaseAccountInformationService.class);
    protected static final String V1 = "v1";
    protected static final String CONSENTS = "consents";
    protected static final String ACCOUNTS = "accounts";
    protected static final String TRANSACTIONS = "transactions";
    protected static final String BALANCES = "balances";
    protected static final String CARD_ACCOUNTS = "card-accounts";
    protected final Aspsp aspsp;
    protected final Request.Builder.Interceptor requestBuilderInterceptor;
    private final LinksRewriter linksRewriter;

    public BaseAccountInformationService(Aspsp aspsp, HttpClient httpClient) {
        this(aspsp, httpClient, null, DEFAULT_LINKS_REWRITER);
    }

    public BaseAccountInformationService(Aspsp aspsp, HttpClient httpClient, Request.Builder.Interceptor requestBuilderInterceptor) {
        this(aspsp, httpClient, requestBuilderInterceptor, DEFAULT_LINKS_REWRITER);
    }

    public BaseAccountInformationService(Aspsp aspsp, HttpClient httpClient, LinksRewriter linksRewriter) {
        this(aspsp, httpClient, null, linksRewriter);
    }

    public BaseAccountInformationService(Aspsp aspsp, HttpClient httpClient, Request.Builder.Interceptor requestBuilderInterceptor, LinksRewriter linksRewriter) {
        super(httpClient);
        this.aspsp = aspsp;
        this.requestBuilderInterceptor = requestBuilderInterceptor;
        this.linksRewriter = linksRewriter;
    }

    public Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body) {
        return this.createConsent(requestHeaders, requestParams, body, Function.identity(), ResponseHandlers.jsonResponseHandler(ConsentCreationResponse.class));
    }

    protected <T> Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body, Class<T> klass, Function<T, ConsentCreationResponse> mapper) {
        return this.createConsent(requestHeaders, requestParams, body, mapper, ResponseHandlers.jsonResponseHandler(klass));
    }

    protected <T> Response<ConsentCreationResponse> createConsent(RequestHeaders requestHeaders, RequestParams requestParams, Consents body, Function<T, ConsentCreationResponse> mapper, HttpClient.ResponseHandler<T> responseHandler) {
        this.requireValid(this.validateCreateConsent(requestHeaders, requestParams, body));
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        headersMap = this.addPsuIdHeader(headersMap);
        headersMap = this.addPsuIdTypeHeader(headersMap);
        String bodyString = this.jsonMapper.writeValueAsString(this.jsonMapper.convertValue(body, Consents.class));
        String uri = BaseAccountInformationService.buildUri(this.getConsentBaseUri(), requestParams);
        Response response = this.httpClient.post(uri).jsonBody(bodyString).headers(headersMap).send(this.requestBuilderInterceptor, responseHandler);
        ConsentCreationResponse creationResponse = mapper.apply(response.getBody());
        creationResponse.setLinks(this.linksRewriter.rewrite(creationResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)creationResponse, response.getHeaders());
    }

    public Response<ConsentInformation> getConsentInformation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getConsentInformation(consentId, requestHeaders, requestParams, ConsentInformation.class, Function.identity());
    }

    protected <T> Response<ConsentInformation> getConsentInformation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, Class<T> klass, Function<T, ConsentInformation> mapper) {
        this.requireValid(this.validateGetConsentInformation(consentId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        Response response = this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        ConsentInformation consentInformation = mapper.apply(response.getBody());
        consentInformation.setLinks(this.linksRewriter.rewrite(consentInformation.getLinks()));
        return new Response(response.getStatusCode(), (Object)consentInformation, response.getHeaders());
    }

    public Response<Void> deleteConsent(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateDeleteConsent(consentId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populateDeleteHeaders(requestHeaders.toMap());
        return this.httpClient.delete(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(Void.class));
    }

    public Response<ConsentStatusResponse> getConsentStatus(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetConsentStatus(consentId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "status");
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(ConsentStatusResponse.class));
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateStartConsentAuthorisation(consentId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations");
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        Response response = this.httpClient.post(uri).headers(headersMap).emptyBody(true).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(StartScaProcessResponse.class));
        Optional.ofNullable(response.getBody()).ifPresent(body -> body.setLinks(this.linksRewriter.rewrite(body.getLinks())));
        return response;
    }

    protected <T> Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, Class<T> klass, Function<T, StartScaProcessResponse> mapper) {
        this.requireValid(this.validateStartConsentAuthorisation(consentId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations");
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        Response response = this.httpClient.post(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        StartScaProcessResponse startScaProcessResponse = mapper.apply(response.getBody());
        startScaProcessResponse.setLinks(this.linksRewriter.rewrite(startScaProcessResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)startScaProcessResponse, response.getHeaders());
    }

    public Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.startConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication, StartScaProcessResponse.class, Function.identity());
    }

    protected <T> Response<StartScaProcessResponse> startConsentAuthorisation(String consentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, StartScaProcessResponse> mapper) {
        this.requireValid(this.validateStartConsentAuthorisation(consentId, requestHeaders, requestParams, updatePsuAuthentication));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations");
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response response = this.httpClient.post(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        StartScaProcessResponse startScaProcessResponse = mapper.apply(response.getBody());
        startScaProcessResponse.setLinks(this.linksRewriter.rewrite(startScaProcessResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)startScaProcessResponse, response.getHeaders());
    }

    public Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication, UpdatePsuAuthenticationResponse.class, Function.identity());
    }

    protected <T> Response<UpdatePsuAuthenticationResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, UpdatePsuAuthenticationResponse> mapper) {
        this.requireValid(this.validateUpdateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        headersMap = this.addPsuIdTypeHeader(headersMap);
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        UpdatePsuAuthenticationResponse updatePsuAuthenticationResponse = mapper.apply(response.getBody());
        updatePsuAuthenticationResponse.setLinks(this.linksRewriter.rewrite(updatePsuAuthenticationResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)updatePsuAuthenticationResponse, response.getHeaders());
    }

    public Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod, SelectPsuAuthenticationMethodResponse.class, Function.identity());
    }

    protected <T> Response<SelectPsuAuthenticationMethodResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod, Class<T> klass, Function<T, SelectPsuAuthenticationMethodResponse> mapper) {
        this.requireValid(this.validateUpdateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        headersMap = this.addPsuIdTypeHeader(headersMap);
        String body = this.jsonMapper.writeValueAsString(selectPsuAuthenticationMethod);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        SelectPsuAuthenticationMethodResponse selectPsuAuthenticationMethodResponse = mapper.apply(response.getBody());
        selectPsuAuthenticationMethodResponse.setLinks(this.linksRewriter.rewrite(selectPsuAuthenticationMethodResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)selectPsuAuthenticationMethodResponse, response.getHeaders());
    }

    public Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation) {
        return this.updateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation, ScaStatusResponse.class, Function.identity());
    }

    protected <T> Response<ScaStatusResponse> updateConsentsPsuData(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation, Class<T> klass, Function<T, ScaStatusResponse> mapper) {
        this.requireValid(this.validateUpdateConsentsPsuData(consentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation));
        String uri = this.getUpdateConsentPsuDataUri(consentId, authorisationId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        headersMap = this.addPsuIdTypeHeader(headersMap);
        String body = this.jsonMapper.writeValueAsString(transactionAuthorisation);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        ScaStatusResponse scaStatusResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)scaStatusResponse, response.getHeaders());
    }

    protected String getUpdateConsentPsuDataUri(String consentId, String authorisationId) {
        return StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
    }

    public Response<AccountListHolder> getAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetAccountList(requestHeaders, requestParams));
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        headersMap = this.addConsentIdHeader(headersMap);
        String uri = BaseAccountInformationService.buildUri(this.getAccountsBaseUri(), requestParams);
        Response response = this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(AccountListHolder.class));
        Optional.ofNullable(response.getBody()).map(AccountListHolder::getAccounts).ifPresent(accounts -> accounts.forEach(account -> account.setLinks(this.linksRewriter.rewrite(account.getLinks()))));
        return response;
    }

    public Response<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getTransactionList(accountId, requestHeaders, requestParams, TransactionsReport.class, Function.identity());
    }

    private String getTransactionListUri(String accountId, RequestParams requestParams) {
        String uri = StringUri.fromElements(this.getAccountsBaseUri(), accountId, TRANSACTIONS);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        return uri;
    }

    protected <T> Response<TransactionsReport> getTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams, Class<T> klass, Function<T, TransactionsReport> mapper) {
        this.requireValid(this.validateGetTransactionList(accountId, requestHeaders, requestParams));
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        headersMap.put("Accept", "application/json");
        String uri = this.getTransactionListUri(accountId, requestParams);
        Response response = this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        TransactionsReport transactionsReport = mapper.apply(response.getBody());
        this.logTransactionsSize(transactionsReport);
        transactionsReport.setLinks(this.linksRewriter.rewrite(transactionsReport.getLinks()));
        Optional.ofNullable(transactionsReport.getTransactions()).ifPresent(report -> {
            report.setLinks(this.linksRewriter.rewrite(report.getLinks()));
            this.rewriteTransactionsLinks(report.getBooked());
            this.rewriteTransactionsLinks(report.getPending());
        });
        return new Response(response.getStatusCode(), (Object)transactionsReport, response.getHeaders());
    }

    private void rewriteTransactionsLinks(List<Transactions> transactions) {
        Optional.ofNullable(transactions).ifPresent(ts -> ts.forEach(transaction -> transaction.setLinks(this.linksRewriter.rewrite(transaction.getLinks()))));
    }

    private void logTransactionsSize(TransactionsReport transactionsReport) {
        int size = 0;
        if (transactionsReport != null && transactionsReport.getTransactions() != null) {
            AccountReport transactions = transactionsReport.getTransactions();
            if (transactions.getPending() != null) {
                size += transactions.getPending().size();
            }
            if (transactions.getBooked() != null) {
                size += transactions.getBooked().size();
            }
        }
        logger.info("<-- There are {} transactions in the response", (Object)size);
    }

    public Response<TransactionDetails> getTransactionDetails(String accountId, String transactionId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetTransactionDetails(accountId, transactionId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getAccountsBaseUri(), accountId, TRANSACTIONS, transactionId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Response response = this.httpClient.get(uri).headers(this.populateGetHeaders(requestHeaders.toMap())).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(TransactionDetails.class));
        Optional.ofNullable(response.getBody()).map(TransactionDetails::getTransactionsDetails).ifPresent(t -> t.setLinks(this.linksRewriter.rewrite(t.getLinks())));
        return new Response(response.getStatusCode(), response.getBody(), response.getHeaders());
    }

    public Response<String> getTransactionListAsString(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetTransactionListAsString(accountId, requestHeaders, requestParams));
        String uri = this.getTransactionListUri(accountId, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        Response response = this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.stringResponseHandler());
        logger.info("<-- There is no information about transactions");
        return response;
    }

    public Response<ScaStatusResponse> getConsentScaStatus(String consentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetConsentScaStatus(consentId, authorisationId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getConsentBaseUri(), consentId, "authorisations", authorisationId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(ScaStatusResponse.class));
    }

    public Response<BalanceReport> getBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        return this.getBalances(accountId, requestHeaders, requestParams, BalanceReport.class, Function.identity());
    }

    public Response<CardAccountList> getCardAccountList(RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetCardAccountList(requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getBaseUri(), V1, CARD_ACCOUNTS);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        Response response = this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(CardAccountList.class));
        Optional.ofNullable(response.getBody()).map(CardAccountList::getCardAccounts).ifPresent(accounts -> accounts.forEach(account -> account.setLinks(this.linksRewriter.rewrite(account.getLinks()))));
        return response;
    }

    public Response<CardAccountDetailsHolder> getCardAccountDetails(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetCardAccountDetails(accountId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getBaseUri(), V1, CARD_ACCOUNTS, accountId);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        Response response = this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(CardAccountDetailsHolder.class));
        Optional.ofNullable(response.getBody()).map(CardAccountDetailsHolder::getCardAccount).ifPresent(account -> account.setLinks(this.linksRewriter.rewrite(account.getLinks())));
        return response;
    }

    public Response<CardAccountBalanceReport> getCardAccountBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetCardAccountBalances(accountId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getBaseUri(), V1, CARD_ACCOUNTS, accountId, BALANCES);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(CardAccountBalanceReport.class));
    }

    public Response<CardAccountsTransactions> getCardAccountTransactionList(String accountId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetCardAccountTransactionList(accountId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getBaseUri(), V1, CARD_ACCOUNTS, accountId, TRANSACTIONS);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        Response response = this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(CardAccountsTransactions.class));
        CardAccountsTransactions body = (CardAccountsTransactions)response.getBody();
        if (body != null) {
            body.setLinks(this.linksRewriter.rewrite(body.getLinks()));
            CardAccountReport cardTransactions = body.getCardTransactions();
            if (cardTransactions != null) {
                cardTransactions.setLinks(this.linksRewriter.rewrite(cardTransactions.getLinks()));
            }
        }
        return response;
    }

    protected <T> Response<BalanceReport> getBalances(String accountId, RequestHeaders requestHeaders, RequestParams requestParams, Class<T> klass, Function<T, BalanceReport> mapper) {
        this.requireValid(this.validateGetBalances(accountId, requestHeaders, requestParams));
        String uri = StringUri.fromElements(this.getAccountsBaseUri(), accountId, BALANCES);
        uri = BaseAccountInformationService.buildUri(uri, requestParams);
        Map<String, String> headers = this.populateGetHeaders(requestHeaders.toMap());
        Response response = this.httpClient.get(uri).headers(headers).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        BalanceReport balanceReport = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)balanceReport, response.getHeaders());
    }

    protected String getBaseUri() {
        return this.aspsp.getUrl();
    }

    protected String getIdpUri() {
        return this.aspsp.getIdpUrl();
    }

    protected String getConsentBaseUri() {
        return StringUri.fromElements(this.getBaseUri(), V1, CONSENTS);
    }

    protected String getAccountsBaseUri() {
        return StringUri.fromElements(this.getBaseUri(), V1, ACCOUNTS);
    }
}

