/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.adapter.mapper.TokenResponseMapper;
import de.adorsys.xs2a.adapter.adapter.model.OauthToken;
import de.adorsys.xs2a.adapter.adapter.oauth2.api.model.AuthorisationServerMetaData;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.UriBuilder;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOauth2Service
implements Oauth2Service {
    private static final Logger logger = LoggerFactory.getLogger(BaseOauth2Service.class);
    private final HttpClient httpClient;
    private final Aspsp aspsp;
    private final TokenResponseMapper tokenResponseMapper = (TokenResponseMapper)Mappers.getMapper(TokenResponseMapper.class);

    public BaseOauth2Service(Aspsp aspsp, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.aspsp = aspsp;
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        return UriBuilder.fromUri(this.getAuthorizationEndpoint(parameters)).queryParam("response_type", Oauth2Service.ResponseType.CODE.toString()).queryParam("state", parameters.getState()).queryParam("redirect_uri", parameters.getRedirectUri()).queryParam("scope", parameters.getScope()).build();
    }

    private String getAuthorizationEndpoint(Oauth2Service.Parameters parameters) {
        String authorizationEndpoint = parameters.getAuthorizationEndpoint();
        if (authorizationEndpoint != null) {
            logger.debug("Get Authorisation Request URI: resolved on the adapter side");
            return authorizationEndpoint;
        }
        AuthorisationServerMetaData metadata = this.getAuthorizationServerMetadata(parameters);
        return metadata.getAuthorisationEndpoint();
    }

    private AuthorisationServerMetaData getAuthorizationServerMetadata(Oauth2Service.Parameters parameters) {
        String scaOAuthLink = parameters.removeScaOAuthLink();
        String metadataUri = scaOAuthLink != null ? scaOAuthLink : this.aspsp.getIdpUrl();
        return (AuthorisationServerMetaData)this.httpClient.get(metadataUri).send(ResponseHandlers.jsonResponseHandler(AuthorisationServerMetaData.class)).getBody();
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        Response response = this.httpClient.post(this.getTokenEndpoint(parameters)).urlEncodedBody(parameters.asMap()).send(ResponseHandlers.jsonResponseHandler(OauthToken.class));
        return this.tokenResponseMapper.map((OauthToken)response.getBody());
    }

    private String getTokenEndpoint(Oauth2Service.Parameters parameters) {
        String tokenEndpoint = parameters.removeTokenEndpoint();
        if (tokenEndpoint != null) {
            return tokenEndpoint;
        }
        return this.getAuthorizationServerMetadata(parameters).getTokenEndpoint();
    }
}

