/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.adapter.AbstractService;
import de.adorsys.xs2a.adapter.adapter.PaymentProduct;
import de.adorsys.xs2a.adapter.adapter.StandardPaymentProduct;
import de.adorsys.xs2a.adapter.adapter.link.identity.IdentityLinksRewriter;
import de.adorsys.xs2a.adapter.http.HttpClient;
import de.adorsys.xs2a.adapter.http.Request;
import de.adorsys.xs2a.adapter.http.ResponseHandlers;
import de.adorsys.xs2a.adapter.http.StringUri;
import de.adorsys.xs2a.adapter.service.PaymentInitiationService;
import de.adorsys.xs2a.adapter.service.RequestHeaders;
import de.adorsys.xs2a.adapter.service.RequestParams;
import de.adorsys.xs2a.adapter.service.Response;
import de.adorsys.xs2a.adapter.service.link.LinksRewriter;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationAuthorisationResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationRequestResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.PaymentInitiationStatus;
import de.adorsys.xs2a.adapter.service.model.ScaStatusResponse;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethod;
import de.adorsys.xs2a.adapter.service.model.SelectPsuAuthenticationMethodResponse;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationInformationWithStatusResponse;
import de.adorsys.xs2a.adapter.service.model.StartScaProcessResponse;
import de.adorsys.xs2a.adapter.service.model.TransactionAuthorisation;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.adapter.service.model.UpdatePsuAuthenticationResponse;
import java.util.Map;
import java.util.function.Function;

public class BasePaymentInitiationService
extends AbstractService
implements PaymentInitiationService {
    private static final LinksRewriter DEFAULT_LINKS_REWRITER = new IdentityLinksRewriter();
    protected static final String V1 = "v1";
    protected static final String PAYMENTS = "payments";
    protected final String baseUri;
    private final Request.Builder.Interceptor requestBuilderInterceptor;
    private final LinksRewriter linksRewriter;

    public BasePaymentInitiationService(String baseUri, HttpClient httpClient) {
        this(baseUri, httpClient, null, DEFAULT_LINKS_REWRITER);
    }

    public BasePaymentInitiationService(String baseUri, HttpClient httpClient, Request.Builder.Interceptor requestBuilderInterceptor) {
        this(baseUri, httpClient, requestBuilderInterceptor, DEFAULT_LINKS_REWRITER);
    }

    public BasePaymentInitiationService(String baseUri, HttpClient httpClient, LinksRewriter linksRewriter) {
        this(baseUri, httpClient, null, linksRewriter);
    }

    public BasePaymentInitiationService(String baseUri, HttpClient httpClient, Request.Builder.Interceptor requestBuilderInterceptor, LinksRewriter linksRewriter) {
        super(httpClient);
        this.baseUri = baseUri;
        this.requestBuilderInterceptor = requestBuilderInterceptor;
        this.linksRewriter = linksRewriter;
    }

    public Response<PaymentInitiationRequestResponse> initiateSinglePayment(String paymentProduct, RequestHeaders requestHeaders, RequestParams requestParams, Object body) {
        return this.initiateSinglePayment(StandardPaymentProduct.fromSlug(paymentProduct), body, requestHeaders, requestParams, PaymentInitiationRequestResponse.class, Function.identity());
    }

    protected <T> Response<PaymentInitiationRequestResponse> initiateSinglePayment(StandardPaymentProduct paymentProduct, Object body, RequestHeaders requestHeaders, RequestParams requestParams, Class<T> klass, Function<T, PaymentInitiationRequestResponse> mapper) {
        String bodyString;
        this.requireValid(this.validateInitiateSinglePayment(paymentProduct.getSlug(), requestHeaders, requestParams, body));
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        switch (paymentProduct.getMediaType()) {
            case "application/json": {
                bodyString = this.jsonMapper.writeValueAsString(this.jsonMapper.convertValue(body, this.getSinglePaymentInitiationBodyClass()));
                break;
            }
            case "application/xml": {
                bodyString = (String)body;
                headersMap.put("Content-Type", "application/xml");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported payment product media type");
            }
        }
        String uri = StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct.getSlug());
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Response response = this.httpClient.post(uri).jsonBody(bodyString).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        PaymentInitiationRequestResponse paymentInitiationRequestResponse = mapper.apply(response.getBody());
        paymentInitiationRequestResponse.setLinks(this.linksRewriter.rewrite(paymentInitiationRequestResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)paymentInitiationRequestResponse, response.getHeaders());
    }

    public Response<SinglePaymentInitiationInformationWithStatusResponse> getSinglePaymentInformation(String paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetSinglePaymentInformation(paymentProduct, paymentId, requestHeaders, requestParams));
        return this.getSinglePaymentInformation(StandardPaymentProduct.fromSlug(paymentProduct), paymentId, requestHeaders, requestParams);
    }

    private Response<SinglePaymentInitiationInformationWithStatusResponse> getSinglePaymentInformation(StandardPaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        String uri = StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct.getSlug(), paymentId);
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(SinglePaymentInitiationInformationWithStatusResponse.class));
    }

    public Response<PaymentInitiationScaStatusResponse> getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams) {
        throw new UnsupportedOperationException();
    }

    public Response<PaymentInitiationStatus> getSinglePaymentInitiationStatus(String paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetSinglePaymentInitiationStatus(paymentProduct, paymentProduct, requestHeaders, requestParams));
        return this.getSinglePaymentInitiationStatus(StandardPaymentProduct.fromSlug(paymentProduct), paymentId, requestHeaders, requestParams);
    }

    private Response<PaymentInitiationStatus> getSinglePaymentInitiationStatus(StandardPaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        String uri = this.getSinglePaymentInitiationStatusUri(paymentProduct.getSlug(), paymentId);
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(PaymentInitiationStatus.class));
    }

    public Response<String> getSinglePaymentInitiationStatusAsString(String paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        this.requireValid(this.validateGetSinglePaymentInitiationStatusAsString(paymentProduct, paymentId, requestHeaders, requestParams));
        String uri = this.getSinglePaymentInitiationStatusUri(paymentProduct, paymentId);
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populateGetHeaders(requestHeaders.toMap());
        return this.httpClient.get(uri).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.stringResponseHandler());
    }

    private String getSinglePaymentInitiationStatusUri(String paymentProduct, String paymentId) {
        return StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct, paymentId, "status");
    }

    public Response<PaymentInitiationAuthorisationResponse> getPaymentInitiationAuthorisation(String paymentService, String paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams) {
        throw new UnsupportedOperationException();
    }

    public Response<StartScaProcessResponse> startSinglePaymentAuthorisation(String paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.startSinglePaymentAuthorisation(StandardPaymentProduct.fromSlug(paymentProduct), paymentId, requestHeaders, requestParams, updatePsuAuthentication, StartScaProcessResponse.class, Function.identity());
    }

    protected <T> Response<StartScaProcessResponse> startSinglePaymentAuthorisation(PaymentProduct paymentProduct, String paymentId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, StartScaProcessResponse> mapper) {
        this.requireValid(this.validateStartSinglePaymentAuthorisation(paymentProduct.getSlug(), paymentId, requestHeaders, requestParams, updatePsuAuthentication));
        String uri = StringUri.fromElements(this.getSinglePaymentBaseUri(), paymentProduct.getSlug(), paymentId, "authorisations");
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePostHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response response = this.httpClient.post(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        StartScaProcessResponse startScaProcessResponse = mapper.apply(response.getBody());
        startScaProcessResponse.setLinks(this.linksRewriter.rewrite(startScaProcessResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)startScaProcessResponse, response.getHeaders());
    }

    public Response<UpdatePsuAuthenticationResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication) {
        return this.updatePaymentPsuData(paymentService, (PaymentProduct)StandardPaymentProduct.fromSlug(paymentProduct), paymentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication, UpdatePsuAuthenticationResponse.class, Function.identity());
    }

    protected <T> Response<UpdatePsuAuthenticationResponse> updatePaymentPsuData(String paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, UpdatePsuAuthentication updatePsuAuthentication, Class<T> klass, Function<T, UpdatePsuAuthenticationResponse> mapper) {
        this.requireValid(this.validateUpdatePaymentPsuData(paymentService, paymentProduct.getSlug(), paymentId, authorisationId, requestHeaders, requestParams, updatePsuAuthentication));
        String uri = StringUri.fromElements(this.getPaymentBaseUri(), paymentService, paymentProduct.getSlug(), paymentId, "authorisations", authorisationId);
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(updatePsuAuthentication);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        UpdatePsuAuthenticationResponse updatePsuAuthenticationResponse = mapper.apply(response.getBody());
        updatePsuAuthenticationResponse.setLinks(this.linksRewriter.rewrite(updatePsuAuthenticationResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)updatePsuAuthenticationResponse, response.getHeaders());
    }

    public Response<SelectPsuAuthenticationMethodResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod) {
        return this.updatePaymentPsuData(paymentService, (PaymentProduct)StandardPaymentProduct.fromSlug(paymentProduct), paymentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod, SelectPsuAuthenticationMethodResponse.class, Function.identity());
    }

    protected <T> Response<SelectPsuAuthenticationMethodResponse> updatePaymentPsuData(String paymentService, PaymentProduct paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, SelectPsuAuthenticationMethod selectPsuAuthenticationMethod, Class<T> klass, Function<T, SelectPsuAuthenticationMethodResponse> mapper) {
        this.requireValid(this.validateUpdatePaymentPsuData(paymentService, paymentProduct.getSlug(), paymentId, authorisationId, requestHeaders, requestParams, selectPsuAuthenticationMethod));
        String uri = StringUri.fromElements(this.getPaymentBaseUri(), paymentService, paymentProduct.getSlug(), paymentId, "authorisations", authorisationId);
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(selectPsuAuthenticationMethod);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        SelectPsuAuthenticationMethodResponse selectPsuAuthenticationMethodResponse = mapper.apply(response.getBody());
        selectPsuAuthenticationMethodResponse.setLinks(this.linksRewriter.rewrite(selectPsuAuthenticationMethodResponse.getLinks()));
        return new Response(response.getStatusCode(), (Object)selectPsuAuthenticationMethodResponse, response.getHeaders());
    }

    public Response<ScaStatusResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation) {
        return this.updatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation, ScaStatusResponse.class, Function.identity());
    }

    protected <T> Response<ScaStatusResponse> updatePaymentPsuData(String paymentService, String paymentProduct, String paymentId, String authorisationId, RequestHeaders requestHeaders, RequestParams requestParams, TransactionAuthorisation transactionAuthorisation, Class<T> klass, Function<T, ScaStatusResponse> mapper) {
        this.requireValid(this.validateUpdatePaymentPsuData(paymentService, paymentProduct, paymentId, authorisationId, requestHeaders, requestParams, transactionAuthorisation));
        String uri = this.getUpdatePaymentPsuDataUri(paymentService, paymentProduct, paymentId, authorisationId);
        uri = BasePaymentInitiationService.buildUri(uri, requestParams);
        Map<String, String> headersMap = this.populatePutHeaders(requestHeaders.toMap());
        String body = this.jsonMapper.writeValueAsString(transactionAuthorisation);
        Response response = this.httpClient.put(uri).jsonBody(body).headers(headersMap).send(this.requestBuilderInterceptor, ResponseHandlers.jsonResponseHandler(klass));
        ScaStatusResponse scaStatusResponse = mapper.apply(response.getBody());
        return new Response(response.getStatusCode(), (Object)scaStatusResponse, response.getHeaders());
    }

    protected String getUpdatePaymentPsuDataUri(String paymentService, String paymentProduct, String paymentId, String authorisationId) {
        return StringUri.fromElements(this.getPaymentBaseUri(), paymentService, paymentProduct, paymentId, "authorisations", authorisationId);
    }

    protected String getSinglePaymentBaseUri() {
        return StringUri.fromElements(this.getPaymentBaseUri(), PAYMENTS);
    }

    protected String getPaymentBaseUri() {
        return StringUri.fromElements(this.baseUri, V1);
    }
}

