/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a.adapter.adapter;

import de.adorsys.xs2a.adapter.http.UriBuilder;
import de.adorsys.xs2a.adapter.service.Oauth2Service;
import de.adorsys.xs2a.adapter.service.Pkcs12KeyStore;
import de.adorsys.xs2a.adapter.service.model.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStoreException;
import java.util.Map;

public class CertificateSubjectClientIdOauth2Service
implements Oauth2Service {
    private final Oauth2Service oauth2Service;
    private final Pkcs12KeyStore keyStore;

    public CertificateSubjectClientIdOauth2Service(Oauth2Service oauth2Service, Pkcs12KeyStore keyStore) {
        this.oauth2Service = oauth2Service;
        this.keyStore = keyStore;
    }

    public URI getAuthorizationRequestUri(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        return UriBuilder.fromUri(this.oauth2Service.getAuthorizationRequestUri(headers, parameters)).queryParam("client_id", this.clientId(parameters)).build();
    }

    private String clientId(Oauth2Service.Parameters parameters) {
        String clientId = parameters.getClientId();
        if (clientId != null) {
            return clientId;
        }
        try {
            return this.keyStore.getOrganizationIdentifier();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenResponse getToken(Map<String, String> headers, Oauth2Service.Parameters parameters) throws IOException {
        parameters.setClientId(this.clientId(parameters));
        return this.oauth2Service.getToken(headers, parameters);
    }
}

